/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.grafico;

import br.com.schneider.sgm.config.PathConfig;
import br.com.schneider.sgm.grafico.Grafico;
import br.com.schneider.sgm.historico.HistoricoConsumo;
import br.com.schneider.sgm.internacionalizacao.Idioma;
import java.awt.Color;
import java.awt.GradientPaint;
import java.util.ResourceBundle;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.Legend;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.BarRenderer;
import org.jfree.data.DefaultCategoryDataset;

public class GraficoSemanaMes
extends Grafico {
    private static final long serialVersionUID = 336793293486203969L;
    private String[] semanas;
    private String mes;
    private DefaultCategoryDataset dataset;
    private String[] graficoID;
    private NumberAxis rangeAxis;
    private JFreeChart chart;
    private double valorKW;

    public GraficoSemanaMes(double valorKW) {
        this.valorKW = valorKW;
        this.semanas = new String[6];
        this.semanas[0] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("sem_1");
        this.semanas[1] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("sem_2");
        this.semanas[2] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("sem_3");
        this.semanas[3] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("sem_4");
        this.semanas[4] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("sem_5");
        this.semanas[5] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("media");
        this.graficoID = new String[4];
        this.graficoID[0] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("CONSUMO_MENSAL");
        this.graficoID[1] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Tempo");
        this.graficoID[2] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Consumo");
        this.graficoID[3] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("media");
        this.dataset = new DefaultCategoryDataset();
        this.dataset.addValue(0.0, (Comparable)((Object)this.graficoID[3]), (Comparable)((Object)this.semanas[5]));
        int i = 0;
        while (i < 5) {
            this.dataset.addValue(500.0, (Comparable)((Object)"valor"), (Comparable)((Object)this.semanas[i]));
            this.dataset.addValue(0.0, (Comparable)((Object)this.graficoID[2]), (Comparable)((Object)this.semanas[i]));
            ++i;
        }
        this.chart = ChartFactory.createBarChart(this.graficoID[0], this.graficoID[1], null, this.dataset, PlotOrientation.HORIZONTAL, true, true, false);
        Legend leg = this.chart.getLegend();
        leg.setAnchor(2);
        CategoryPlot plot = this.chart.getCategoryPlot();
        this.rangeAxis = (NumberAxis)plot.getRangeAxis();
        this.rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        StandardCategoryItemLabelGenerator std = new StandardCategoryItemLabelGenerator();
        std.generateToolTip(this.dataset, 1, 1);
        renderer.setLabelGenerator(std);
        renderer.setItemLabelsVisible(true);
        renderer.setDrawBarOutline(false);
        renderer.setMaxBarWidth(1.0);
        GradientPaint gp0 = new GradientPaint(0.0f, 0.0f, Color.blue, 0.0f, 0.0f, Color.lightGray);
        GradientPaint gp1 = new GradientPaint(0.0f, 0.0f, Color.green, 0.0f, 0.0f, Color.lightGray);
        GradientPaint gp2 = new GradientPaint(0.0f, 0.0f, Color.red, 0.0f, 0.0f, Color.lightGray);
        renderer.setSeriesPaint(0, gp0);
        renderer.setSeriesPaint(1, gp1);
        renderer.setSeriesPaint(2, gp2);
        this.chart.setBackgroundPaint(new Color(230, 230, 230));
        ChartPanel chartPanel = new ChartPanel(this.chart, false, true, true, false, true);
        this.add(chartPanel);
    }

    public void setValorKW(double d) {
        this.valorKW = d;
        this.setValor();
    }

    public void setValor() {
        int i = 0;
        while (i < 5) {
            float f = this.dataset.getValue((Comparable)((Object)this.graficoID[2]), (Comparable)((Object)this.semanas[i])).floatValue();
            this.dataset.addValue((double)f * this.valorKW, (Comparable)((Object)"valor (R$)"), (Comparable)((Object)this.semanas[i]));
            ++i;
        }
    }

    public void validarIdioma() {
        this.chart.setTitle(ResourceBundle.getBundle(Idioma.getIdioma()).getString("CONSUMO_MENSAL"));
        this.chart.getCategoryPlot().getDomainAxis().setLabel(ResourceBundle.getBundle(Idioma.getIdioma()).getString("Tempo"));
        float[] aux = new float[5];
        int i = 0;
        while (i < 5) {
            aux[i] = this.dataset.getValue((Comparable)((Object)this.graficoID[2]), (Comparable)((Object)this.semanas[i])).floatValue();
            ++i;
        }
        this.dataset.clear();
        this.semanas[0] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("sem_1");
        this.semanas[1] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("sem_2");
        this.semanas[2] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("sem_3");
        this.semanas[3] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("sem_4");
        this.semanas[4] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("sem_5");
        this.semanas[5] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("media");
        this.graficoID[3] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("media");
        this.graficoID[2] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Consumo");
        this.dataset.addValue(0.0, (Comparable)((Object)this.graficoID[3]), (Comparable)((Object)this.semanas[5]));
        i = 0;
        while (i < 5) {
            this.dataset.addValue((double)aux[i] * this.valorKW, (Comparable)((Object)"valor (R$)"), (Comparable)((Object)this.semanas[i]));
            this.dataset.addValue(aux[i], (Comparable)((Object)this.graficoID[2]), (Comparable)((Object)this.semanas[i]));
            ++i;
        }
        this.media();
    }

    public double media() {
        double aux = 0.0;
        int cont = 0;
        int i = 0;
        while (i < 5) {
            if (this.dataset.getValue((Comparable)((Object)this.graficoID[2]), (Comparable)((Object)this.semanas[i])).doubleValue() != 0.0) {
                ++cont;
                aux += this.dataset.getValue((Comparable)((Object)this.graficoID[2]), (Comparable)((Object)this.semanas[i])).doubleValue();
            }
            ++i;
        }
        this.dataset.addValue(aux /= (double)cont, (Comparable)((Object)this.graficoID[3]), (Comparable)((Object)this.semanas[5]));
        return aux;
    }

    public void setMes(String str) {
        this.mes = str;
        this.leXML();
    }

    public int getMes() {
        String[] aux = this.mes.split("-");
        return Integer.parseInt(aux[0]);
    }

    public void leXML() {
        int i = 0;
        while (i < 5) {
            this.addValue(0.0, i);
            ++i;
        }
        HistoricoConsumo h = new HistoricoConsumo(String.valueOf(PathConfig.getPathXML()) + "consumo.xml");
        String[] result = h.getConsumoSemanal(this.mes).split(", ");
        String[] valor = new String[5];
        int j = 0;
        while (j < result.length) {
            try {
                int i2 = 0;
                while (i2 < result.length) {
                    String[] aux = result[i2].split("=");
                    String[] aux0 = aux[0].split("-");
                    valor[i2] = aux[1];
                    int a = Integer.valueOf(aux0[2]);
                    if (valor[i2] != null) {
                        this.addValue(Double.parseDouble(valor[i2]), a - 1);
                    }
                    ++i2;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            ++j;
        }
    }

    public void addValue(double d, int semana) {
        this.dataset.addValue(d, (Comparable)((Object)this.graficoID[2]), (Comparable)((Object)this.semanas[semana]));
        this.dataset.addValue(d * this.valorKW, (Comparable)((Object)"valor (R$)"), (Comparable)((Object)this.semanas[semana]));
        this.media();
        this.rangeAxis.setUpperMargin(0.2);
    }

    public DefaultCategoryDataset getDataSet() {
        return this.dataset;
    }

    public DefaultCategoryDataset createDataset() {
        this.dataset = new DefaultCategoryDataset();
        this.dataset.addValue(3.0, (Comparable)((Object)this.graficoID[2]), (Comparable)((Object)this.semanas[12]));
        int i = 0;
        while (i < 5) {
            this.dataset.addValue(0.0, (Comparable)((Object)this.graficoID[2]), (Comparable)((Object)this.semanas[i]));
            ++i;
        }
        return this.dataset;
    }
}

