/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.grafico;

import br.com.schneider.sgm.config.PathConfig;
import br.com.schneider.sgm.grafico.Grafico;
import br.com.schneider.sgm.historico.HistoricoConsumo;
import br.com.schneider.sgm.internacionalizacao.Idioma;
import java.awt.Color;
import java.awt.GradientPaint;
import java.util.ResourceBundle;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.Legend;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.BarRenderer;
import org.jfree.data.DefaultCategoryDataset;

public class GraficoMesAno
extends Grafico {
    private static final long serialVersionUID = 8978898621505921552L;
    ChartPanel chartPanel;
    DefaultCategoryDataset dataset;
    private String[] meses;
    private String[] graficoID;
    private int cont;
    private NumberAxis rangeAxis;
    private JFreeChart chart;
    private double valorKW;
    private String ano;

    public GraficoMesAno(double valor) {
        this.valorKW = valor;
        this.meses = new String[13];
        this.meses[0] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Jan");
        this.meses[1] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Fev");
        this.meses[2] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Mar");
        this.meses[3] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Abr");
        this.meses[4] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Mai");
        this.meses[5] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Jun");
        this.meses[6] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Jul");
        this.meses[7] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Ago");
        this.meses[8] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Set");
        this.meses[9] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Out");
        this.meses[10] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Nov");
        this.meses[11] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Dez");
        this.meses[12] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Med");
        this.graficoID = new String[5];
        this.graficoID[0] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("CONSUMO_ANUAL");
        this.graficoID[1] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Tempo");
        this.graficoID[2] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Consumo");
        this.graficoID[3] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("media");
        this.graficoID[4] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Consumo");
        this.dataset = new DefaultCategoryDataset();
        this.dataset.addValue(0.0, (Comparable)((Object)this.graficoID[3]), (Comparable)((Object)this.meses[12]));
        int i = 0;
        while (i < 12) {
            this.dataset.addValue(0.0, (Comparable)((Object)"valor (R$)"), (Comparable)((Object)this.meses[i]));
            this.dataset.addValue(0.0, (Comparable)((Object)this.graficoID[4]), (Comparable)((Object)this.meses[i]));
            ++i;
        }
        this.chart = ChartFactory.createBarChart(this.graficoID[0], this.graficoID[1], null, this.dataset, PlotOrientation.HORIZONTAL, true, true, false);
        Legend leg = this.chart.getLegend();
        leg.setAnchor(2);
        CategoryPlot plot = this.chart.getCategoryPlot();
        this.rangeAxis = (NumberAxis)plot.getRangeAxis();
        this.rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        renderer.setDrawBarOutline(true);
        GradientPaint gp0 = new GradientPaint(0.0f, 0.0f, Color.blue, 0.0f, 0.0f, Color.lightGray);
        GradientPaint gp1 = new GradientPaint(0.0f, 0.0f, Color.green, 0.0f, 0.0f, Color.lightGray);
        GradientPaint gp2 = new GradientPaint(0.0f, 0.0f, Color.red, 0.0f, 0.0f, Color.lightGray);
        renderer.setSeriesPaint(0, gp0);
        renderer.setSeriesPaint(1, gp1);
        renderer.setSeriesPaint(2, gp2);
        this.chart.setBackgroundPaint(new Color(230, 230, 230));
        ChartPanel chartPanel = new ChartPanel(this.chart, false, true, true, false, true);
        this.add(chartPanel);
    }

    public double[] passaValores() {
        double[] d = new double[13];
        int i = 0;
        while (i < 11) {
            d[i] = this.dataset.getValue((Comparable)((Object)this.graficoID[2]), (Comparable)((Object)this.meses[i])).doubleValue();
            ++i;
        }
        d[12] = this.dataset.getValue((Comparable)((Object)this.graficoID[3]), (Comparable)((Object)this.meses[12])).equals(new Double(Double.NaN)) ? 0.0 : this.dataset.getValue((Comparable)((Object)this.graficoID[3]), (Comparable)((Object)this.meses[12])).doubleValue();
        return d;
    }

    public void validarIdioma() {
        this.chart.setTitle(ResourceBundle.getBundle(Idioma.getIdioma()).getString("CONSUMO_ANUAL"));
        this.chart.getCategoryPlot().getDomainAxis().setLabel(ResourceBundle.getBundle(Idioma.getIdioma()).getString("Tempo"));
        float[] aux = new float[12];
        int i = 0;
        while (i < 11) {
            aux[i] = this.dataset.getValue((Comparable)((Object)this.graficoID[2]), (Comparable)((Object)this.meses[i])).floatValue();
            ++i;
        }
        this.dataset.clear();
        this.meses[0] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Jan");
        this.meses[1] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Fev");
        this.meses[2] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Mar");
        this.meses[3] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Abr");
        this.meses[4] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Mai");
        this.meses[5] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Jun");
        this.meses[6] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Jul");
        this.meses[7] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Ago");
        this.meses[8] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Set");
        this.meses[9] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Out");
        this.meses[10] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Nov");
        this.meses[11] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Dez");
        this.meses[12] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Med");
        this.graficoID[3] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("media");
        this.graficoID[2] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Consumo");
        this.dataset.addValue(0.0, (Comparable)((Object)this.graficoID[3]), (Comparable)((Object)this.meses[12]));
        i = 0;
        while (i < 12) {
            this.dataset.addValue((double)aux[i] * this.valorKW, (Comparable)((Object)"valor (R$)"), (Comparable)((Object)this.meses[i]));
            this.dataset.addValue(aux[i], (Comparable)((Object)this.graficoID[2]), (Comparable)((Object)this.meses[i]));
            ++i;
        }
        this.media();
    }

    public void setValorKW(double d) {
        this.valorKW = d;
        this.setValor();
    }

    public void setValor() {
        int i = 0;
        while (i < 11) {
            float f = this.dataset.getValue((Comparable)((Object)this.graficoID[2]), (Comparable)((Object)this.meses[i])).floatValue();
            this.dataset.addValue((double)f * this.valorKW, (Comparable)((Object)"valor (R$)"), (Comparable)((Object)this.meses[i]));
            ++i;
        }
    }

    public void addValue(double d, int mes) {
        this.dataset.addValue(d, (Comparable)((Object)this.graficoID[4]), (Comparable)((Object)this.meses[mes]));
        this.dataset.addValue(d * this.valorKW, (Comparable)((Object)"valor (R$)"), (Comparable)((Object)this.meses[mes]));
        this.media();
        this.rangeAxis.setUpperMargin(0.2);
    }

    public void setAno(String str) {
        this.ano = str;
        this.leXML();
    }

    public int getAno() {
        String[] aux = this.ano.split("-");
        return Integer.parseInt(aux[0]);
    }

    public void leXML() {
        int i = 0;
        while (i < 12) {
            this.addValue(0.0, i);
            ++i;
        }
        HistoricoConsumo h = new HistoricoConsumo(String.valueOf(PathConfig.getPathXML()) + "consumo.xml");
        String[] data = new String[]{"01-", "02-", "03-", "04-", "05-", "06-", "07-", "08-", "08-", "10-", "11-", "12-"};
        int j = 0;
        while (j < 12) {
            int n = j++;
            data[n] = String.valueOf(data[n]) + this.ano;
        }
        int i2 = 0;
        while (i2 < 12) {
            if (h.getConsumoMensal(data[i2]) != null) {
                this.addValue(Double.parseDouble(h.getConsumoMensal(data[i2])), i2);
            }
            ++i2;
        }
    }

    public double media() {
        double aux = 0.0;
        int cont = 0;
        int i = 0;
        while (i < 11) {
            if (this.dataset.getValue((Comparable)((Object)this.graficoID[2]), (Comparable)((Object)this.meses[i])).doubleValue() != 0.0) {
                ++cont;
                aux += this.dataset.getValue((Comparable)((Object)this.graficoID[2]), (Comparable)((Object)this.meses[i])).doubleValue();
            }
            ++i;
        }
        this.dataset.addValue(aux /= (double)cont, (Comparable)((Object)this.graficoID[3]), (Comparable)((Object)this.meses[12]));
        return aux;
    }

    public DefaultCategoryDataset getDataSet() {
        return this.dataset;
    }

    public void btnDireitaClick() {
        this.dataset.addValue(5.0, (Comparable)((Object)this.graficoID[4]), (Comparable)((Object)this.meses[this.cont++]));
        if (this.cont < 0) {
            this.cont = 0;
        }
        if (this.cont > 11) {
            this.cont = 11;
        }
    }

    public void btnEsquerdaClick() {
        this.dataset.addValue(0.0, (Comparable)((Object)this.graficoID[4]), (Comparable)((Object)this.meses[this.cont--]));
        if (this.cont < 0) {
            this.cont = 0;
        }
        if (this.cont > 11) {
            this.cont = 11;
        }
    }

    public DefaultCategoryDataset createDataset() {
        this.dataset = new DefaultCategoryDataset();
        this.dataset.addValue(3.0, (Comparable)((Object)this.graficoID[4]), (Comparable)((Object)this.meses[12]));
        int i = 0;
        while (i < 12) {
            this.dataset.addValue(0.0, (Comparable)((Object)this.graficoID[4]), (Comparable)((Object)this.meses[i]));
            ++i;
        }
        return this.dataset;
    }
}

