/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.grafico;

import br.com.schneider.sgm.config.PathConfig;
import br.com.schneider.sgm.grafico.Grafico;
import br.com.schneider.sgm.historico.HistoricoConsumo;
import br.com.schneider.sgm.internacionalizacao.Idioma;
import java.awt.Color;
import java.util.ResourceBundle;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class GraficoDiaMes
extends Grafico {
    private static final long serialVersionUID = 2506725394841029557L;
    private TimeSeries free;
    private TimeSeries valores;
    private String[] graficoID;
    private String tempo;
    private DateAxis domain;
    private NumberAxis range;
    private JFreeChart chart;
    private TimeSeriesCollection dataset;
    private double valorKW;
    private String mes;

    public GraficoDiaMes(double valor) {
        this.valorKW = valor;
        this.graficoID = new String[4];
        this.graficoID[0] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Consumo");
        this.graficoID[1] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("CONSUMO_DIARIO");
        this.graficoID[2] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("valor");
        this.tempo = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Tempo");
        this.valores = new TimeSeries(this.graficoID[2], Day.class);
        this.valores.setHistoryCount(1000000000);
        this.free = new TimeSeries(this.graficoID[0], Day.class);
        this.free.setHistoryCount(1000000000);
        this.dataset = new TimeSeriesCollection();
        this.dataset.addSeries(this.free);
        this.dataset.addSeries(this.valores);
        this.domain = new DateAxis(this.tempo);
        this.range = new NumberAxis();
        XYPlot xyplot = new XYPlot(this.dataset, this.domain, this.range, new StandardXYItemRenderer());
        xyplot.setBackgroundPaint(Color.white);
        XYItemRenderer renderer = xyplot.getRenderer();
        renderer.setSeriesPaint(0, Color.red);
        renderer.setSeriesPaint(1, Color.black);
        this.domain.setTickUnit(new DateTickUnit(2, 2));
        this.domain.setAutoRange(true);
        this.domain.setLowerMargin(0.0);
        this.domain.setUpperMargin(0.0);
        this.domain.setTickLabelsVisible(true);
        this.range.setLowerMargin(0.0);
        this.range.setUpperMargin(0.0);
        this.range.setAutoRange(true);
        this.range.setTickLabelsVisible(true);
        this.range.setStandardTickUnits(NumberAxis.createStandardTickUnits());
        this.chart = new JFreeChart(this.graficoID[1], JFreeChart.DEFAULT_TITLE_FONT, xyplot, true);
        this.chart.setBackgroundPaint(new Color(230, 230, 230));
        ChartPanel chartPanel = new ChartPanel(this.chart, false, true, true, false, true);
        this.add(chartPanel);
    }

    public void setMes(String str) {
        this.mes = str;
        this.leXML();
    }

    public int getMes() {
        String[] aux = this.mes.split("-");
        return Integer.parseInt(aux[0]);
    }

    public void leXML() {
        this.free.clear();
        this.valores.clear();
        HistoricoConsumo h = new HistoricoConsumo(String.valueOf(PathConfig.getPathXML()) + "consumo.xml");
        String[] resultado = h.getConsumoDiario(this.mes).split(", ");
        try {
            int i = 0;
            while (i < resultado.length) {
                String[] valor = resultado[i].split("=");
                String[] dia = valor[0].split("-");
                this.addFreeObservation(new Day(Integer.parseInt(dia[2]), Integer.parseInt(dia[1]), Integer.parseInt(dia[0])), Double.parseDouble(valor[1]));
                this.addTotalObservation(new Day(Integer.parseInt(dia[2]), Integer.parseInt(dia[1]), Integer.parseInt(dia[0])), Double.parseDouble(valor[1]) * this.valorKW);
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void validarIdioma() {
        this.free.setName(ResourceBundle.getBundle(Idioma.getIdioma()).getString("Consumo"));
        this.domain.setLabel(ResourceBundle.getBundle(Idioma.getIdioma()).getString("Tempo"));
        this.chart.setTitle(ResourceBundle.getBundle(Idioma.getIdioma()).getString("CONSUMO_DIARIO"));
    }

    private void addFreeObservation(Day d, double y) {
        this.free.add((RegularTimePeriod)d, y);
    }

    public void addValue(double d) {
        this.addFreeObservation(d);
        this.addTotalObservation(d * this.valorKW);
    }

    public void setValorKW(double d) {
        this.valorKW = d;
        this.free.clear();
        this.valores.clear();
        this.leXML();
    }

    private void addTotalObservation(Day d, double y) {
        this.valores.add((RegularTimePeriod)d, y);
    }

    private void addTotalObservation(double y) {
        this.valores.add((RegularTimePeriod)new Day(), y);
    }

    private void addFreeObservation(double y) {
        this.free.add((RegularTimePeriod)new Day(), y);
    }
}

