/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.grafico;

import br.com.schneider.sgm.grafico.Grafico;
import br.com.schneider.sgm.internacionalizacao.Idioma;
import java.awt.Color;
import java.util.ResourceBundle;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.data.SeriesException;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class GraficoBateria
extends Grafico {
    private static final long serialVersionUID = 1006930403322845027L;
    private TimeSeries free;
    private String[] graficoID = new String[3];
    private String tempo;
    private boolean flag = false;
    private DateAxis domain;
    private NumberAxis range;
    private JFreeChart chart;
    private int cont;

    public GraficoBateria() {
        this.graficoID[0] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Tensao_V");
        this.graficoID[1] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("BATERIA");
        this.graficoID[2] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Bateria");
        this.tempo = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Tempo");
        this.free = new TimeSeries(this.graficoID[2], Second.class);
        this.free.setHistoryCount(10000);
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(this.free);
        this.domain = new DateAxis(this.tempo);
        this.range = new NumberAxis(this.graficoID[0]);
        XYPlot xyplot = new XYPlot(dataset, this.domain, this.range, new StandardXYItemRenderer());
        xyplot.setBackgroundPaint(Color.white);
        XYItemRenderer renderer = xyplot.getRenderer();
        renderer.setSeriesPaint(0, Color.red);
        renderer.setSeriesPaint(1, Color.black);
        this.domain.setAutoRange(true);
        this.domain.setLowerMargin(0.0);
        this.domain.setUpperMargin(0.0);
        this.domain.setTickLabelsVisible(true);
        this.range.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        this.chart = new JFreeChart(this.graficoID[1], JFreeChart.DEFAULT_TITLE_FONT, xyplot, true);
        this.chart.setBackgroundPaint(new Color(230, 230, 230));
        ChartPanel chartPanel = new ChartPanel(this.chart, false, true, true, false, true);
        this.add(chartPanel);
    }

    public void validarIdioma() {
        this.domain.setLabel(ResourceBundle.getBundle(Idioma.getIdioma()).getString("Tempo"));
        this.range.setLabel(ResourceBundle.getBundle(Idioma.getIdioma()).getString("Tensao_V"));
        this.chart.setTitle(ResourceBundle.getBundle(Idioma.getIdioma()).getString("BATERIA"));
        this.free.setName(ResourceBundle.getBundle(Idioma.getIdioma()).getString("Bateria"));
    }

    public void stopChart() {
        this.cont = 0;
        this.free.clear();
        this.flag = true;
    }

    public void restartChart() {
        this.flag = false;
    }

    public void addValue(double tensao) {
        if (!this.flag) {
            ++this.cont;
            this.addFreeObservation(tensao);
            if (this.cont == 1800) {
                this.free.clear();
            }
        }
    }

    private void addFreeObservation(double y) {
        try {
            if (!this.flag) {
                this.free.add((RegularTimePeriod)new Second(), y);
            }
        }
        catch (SeriesException seriesException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }
}

