/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.grafico;

import java.awt.BorderLayout;
import java.awt.Color;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public abstract class Grafico
extends JPanel {
    private static final long serialVersionUID = 1L;
    private TimeSeries valores = new TimeSeries("", Millisecond.class);
    private TimeSeries free;
    protected static final int maxCont = 1800;

    public Grafico() {
        super(new BorderLayout());
        this.valores.setHistoryCount(10000);
        this.free = new TimeSeries("", Millisecond.class);
        this.free.setHistoryCount(10000);
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(this.free);
        dataset.addSeries(this.valores);
        DateAxis domain = new DateAxis("Tempo");
        NumberAxis range = new NumberAxis("");
        XYPlot xyplot = new XYPlot(dataset, domain, range, new StandardXYItemRenderer());
        xyplot.setBackgroundPaint(Color.white);
        XYItemRenderer renderer = xyplot.getRenderer();
        renderer.setSeriesPaint(0, Color.red);
        renderer.setSeriesPaint(1, Color.black);
        domain.setAutoRange(true);
        domain.setLowerMargin(0.0);
        domain.setUpperMargin(0.0);
        domain.setTickLabelsVisible(true);
        range.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        JFreeChart chart = new JFreeChart("", JFreeChart.DEFAULT_TITLE_FONT, xyplot, true);
        ChartPanel chartPanel = new ChartPanel(chart);
        this.add(chartPanel);
    }

    private void addTotalObservation(double y) {
        this.valores.add((RegularTimePeriod)new Millisecond(), y);
    }

    private void addFreeObservation(double y) {
        this.free.add((RegularTimePeriod)new Millisecond(), y);
    }
}

