/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.dispositivos;

import br.com.schneider.sgm.dispositivos.PS800;
import br.com.schneider.sgm.eventos.Evento;
import br.com.schneider.sgm.protocolo.ProtocoloPS;
import java.util.GregorianCalendar;

public class Stay1200_USB
extends PS800 {
    protected int estadoReles;

    public Stay1200_USB(ProtocoloPS protocol) {
        super(protocol);
        this.instanciasGlobais();
        protocol.setModeloUPS(10);
    }

    public void instanciasGlobais() {
        this.TENSAO_ENTRADA_F1 = 1.64f;
        this.TENSAO_ENTRADA_F2 = 9.34f;
        this.TENSAO_BATERIA_F1 = 0.1551;
        this.TENSAO_BATERIA_F2 = 0.2525;
        this.TENSAO_MIN_BATERIA = 20.0f;
        this.TENSAO_MAX_BATERIA = 29.5f;
        this.TENSAO_FLUT_BATERIA = 27.0f;
        this.CORRENTE_SAIDA_F1_MR = 0.12970000389100012;
        this.CORRENTE_SAIDA_F2_MR = 0.5387060281204546;
        this.CORRENTE_SAIDA_F1_MI = 0.1372;
        this.CORRENTE_SAIDA_F2_MI = 0.3456;
        this.POTENCIAUTIL_DETECCAO_CURVA1_F1 = new double[]{0.079, 0.089, 0.0972, 0.0, 0.0805, 0.0883, 0.0, 0.0981};
        this.POTENCIAUTIL_DETECCAO_CURVA2_F1 = new double[]{0.0763, 0.081, 0.0919, 0.0, 0.0741, 0.0828, 0.0, 0.0938};
        this.POTENCIAUTIL_DETECCAO_CURVA3_F1 = new double[]{0.0744, 0.0808, 0.0885, 0.0, 0.0732, 0.084, 0.0, 0.0955};
        this.POTENCIAUTIL_DETECCAO_CURVA1_F2 = new double[]{49.107, 45.449, 48.092, 0.0, 43.633, 47.585, 0.0, 48.831};
        this.POTENCIAUTIL_DETECCAO_CURVA2_F2 = new double[]{81.732, 94.459, 86.686, 0.0, 84.657, 84.999, 0.0, 78.097};
        this.POTENCIAUTIL_DETECCAO_CURVA3_F2 = new double[]{122.06, 122.9, 125.75, 0.0, 120.39, 108.52, 0.0, 92.239};
        this.POTENCIAUTIL_CURVA1_F1 = new double[]{0.08040007075206226, 0.0894, 0.0999, 0.0, 0.0813, 0.0905, 0.0, 0.1005};
        this.POTENCIAUTIL_CURVA2_F1 = new double[]{0.08630063689870031, 0.0946, 0.1068, 0.0, 0.086, 0.0967, 0.0, 0.1088};
        this.POTENCIAUTIL_CURVA3_F1 = new double[]{0.0896001146881468, 0.0991, 0.1116, 0.0, 0.0967, 0.1068, 0.0, 0.1169};
        this.POTENCIAUTIL_CURVA1_F2 = new double[]{45.292, 41.928, 41.727, 0.0, 40.269, 41.81, 0.0, 43.458};
        this.POTENCIAUTIL_CURVA2_F2 = new double[]{8.3927, 9.2393, 8.2852, 0.0, 8.301, 6.7636, 0.0, 8.2842};
        this.POTENCIAUTIL_CURVA3_F2 = new double[]{-31.115, -33.777, -33.826, 0.0, -59.513, -57.729, 0.0, -41.333};
        this.TENSAO_SAIDA_F1_MR = new double[]{1.1549, 1.0925, 0.0, 0.0, 1.0929, 1.0885, 0.0, 0.8654262224145391};
        this.TENSAO_SAIDA_F2_MR = new double[]{-6.9157, 11.026, 10.43, 0.0, -0.6109, 12.18, 0.0, 13.677};
        this.TENSAO_SAIDA_F2_MI = new double[]{5.59, 9.47, 13.7, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.TENSAO_SAIDA_F1_MI = new double[]{7.9, 9.1, 17.6, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.autonomia100 = new int[]{26, 25, 24, 23, 22, 21, 20, 18, 17, 16, 14, 13, 11, 9, 7, 4, 2, 1};
    }

    @Override
    public void setSobrecarga(boolean sobrecarga) {
        if (this.potenciaReal > 655.0f) {
            this.sobrecarga = true;
            this.cargaElevada = true;
        } else {
            this.sobrecarga = false;
            this.cargaElevada = false;
        }
    }

    @Override
    public void setPotenciaReal(int potenciaReal) {
        double potVA1 = 5.968 * (double)this.potenciaAparente - 284.36;
        double potVA2 = 7.149 * (double)this.potenciaAparente - 567.18;
        double potLin = 0.1664 * (double)potenciaReal + 49.182;
        double potRe = 0.1519 * (double)potenciaReal + 32.644;
        this.potenciaReal = Math.abs(potVA1 - (double)potenciaReal) < Math.abs(potVA2 - (double)potenciaReal) ? (float)potLin : (float)potRe;
        if ((double)this.correnteSaida < 0.7) {
            this.potenciaReal = this.potenciaAparente;
        }
        if (this.potenciaAparente < this.potenciaReal) {
            float f = this.potenciaAparente;
            this.potenciaAparente = this.potenciaReal;
            this.potenciaReal = f;
        }
    }

    @Override
    public void setAutonomiaBateria(int autonomiaBateria) {
        if (this.potenciaReal < 120.0f) {
            this.autonomiaBateria = Math.round((float)(0.0982 * Math.pow(autonomiaBateria, 2.0) - 27.131 * (double)autonomiaBateria + 1875.18));
            if (this.autonomiaBateria > 60) {
                this.autonomiaBateria = 60;
            }
        } else if (this.potenciaReal < 230.0f) {
            this.autonomiaBateria = Math.round((float)(0.0663 * Math.pow(autonomiaBateria, 2.0) - 18.252 * (double)autonomiaBateria + 1257.2));
            if (this.autonomiaBateria > 30) {
                this.autonomiaBateria = 30;
            }
        } else if (this.potenciaReal < 330.0f) {
            this.autonomiaBateria = Math.round((float)(0.0225 * Math.pow(autonomiaBateria, 2.0) - 5.9113 * (double)autonomiaBateria + 389.08));
            if (this.autonomiaBateria > 13) {
                this.autonomiaBateria = 13;
            }
        } else if (this.potenciaReal < 430.0f) {
            this.autonomiaBateria = Math.round((float)(9.0E-4 * Math.pow(autonomiaBateria, 2.0) + 3.3172 * (double)autonomiaBateria - 272.34));
            if (this.autonomiaBateria > 10) {
                this.autonomiaBateria = 10;
            }
        } else if (this.potenciaReal < 530.0f) {
            this.autonomiaBateria = Math.round((float)(0.5711 * Math.pow(this.tensaoBateria, 2.0) - 23.484 * (double)this.tensaoBateria + 241.81));
            if (this.autonomiaBateria > 8) {
                this.autonomiaBateria = 8;
            }
        } else if (this.potenciaReal < 630.0f) {
            this.autonomiaBateria = Math.round((float)(0.0091 * Math.pow(autonomiaBateria, 2.0) - 2.3133 * (double)autonomiaBateria + 147.62));
            if (this.autonomiaBateria > 8) {
                this.autonomiaBateria = 8;
            }
        }
        if (this.expansorBateria != 0) {
            this.autonomiaBateria = (int)((double)this.autonomiaBateria * ((double)this.expansorBateria / 9.75));
        }
    }

    @Override
    public void setTensaoBateria(int tensaoBateria) {
        this.tensaoBateria = (float)(this.TENSAO_BATERIA_F1 * (double)tensaoBateria + this.TENSAO_BATERIA_F2);
    }

    @Override
    public void setTensaoEntrada(int tensaoEntrada) {
        this.tensaoEntrada = this.isTensaoSaida220() ? (float)((int)(this.TENSAO_ENTRADA_F1 * (float)tensaoEntrada + this.TENSAO_ENTRADA_F2)) : (float)((int)(this.TENSAO_ENTRADA_F1 * (float)tensaoEntrada + this.TENSAO_ENTRADA_F2 - 3.0f));
    }

    @Override
    public void setCorrenteSaida(int correnteSaida) {
        this.correnteSaida = this.modoRede ? (float)(this.CORRENTE_SAIDA_F1_MR * (double)correnteSaida + this.CORRENTE_SAIDA_F2_MR) : (this.saidaLigada ? (float)(this.CORRENTE_SAIDA_F1_MI * (double)correnteSaida + this.CORRENTE_SAIDA_F2_MI) : 0.0f);
        if (correnteSaida == 0) {
            this.correnteSaida = 0.0f;
        }
    }

    @Override
    public boolean isAutoTesteBateriaAvaliable() {
        return true;
    }

    @Override
    public int calculaEstadoBaterias(float bateriaInicial, float bateriaFinal, float Potencia, int tempo) {
        GregorianCalendar calendar = new GregorianCalendar();
        int mesAtual = calendar.get(2) + 1;
        int anoAtual = calendar.get(1);
        Evento evt = new Evento(29, calendar.get(11), calendar.get(12), calendar.get(13), this.getDiaMes(), mesAtual, anoAtual);
        this.protocoloUPS.addEvento(evt);
        return 0;
    }

    @Override
    public void setBateriaBaixa(boolean bateriaBaixa) {
        if (this.modoBateria) {
            this.bateriaBaixa = this.tensaoBateria < 19.0f;
        }
    }
}

