/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.dispositivos;

import br.com.schneider.sgm.eventos.UPSListener;
import br.com.schneider.sgm.protocolo.ProtocoloSolis;
import br.com.schneider.sgm.protocolo.ProtocoloUPS;
import br.com.schneider.sgm.ups.AbstractUPS;

public class SolisM11
extends AbstractUPS {
    protected int contaAutonomiasBaixas;
    protected float temperaturaCritica;
    protected float frequenciaEntradaC;
    protected float tensaoSaida220F1MB;
    protected float tensaoSaida220F2MB;
    protected float tensaoSaida220F1MR;
    protected float tensaoSaida220F2MR;
    protected float tensaoSaida110F1MB;
    protected float tensaoSaida110F2MB;
    protected float tensaoSaida110F1MR;
    protected float tensaoSaida110F2MR;
    protected float tensaoEntradaOffset;
    protected int comparadorTensaoEntrada;
    protected float tensaoEntradaF1193;
    protected float tensaoEntradaF2193;
    protected float tensaoEntradaF1194;
    protected float tensaoEntradaF2194;
    protected float tensaoBateriaF1;
    protected float tensaoBateriaF2;
    protected float correnteSaida220F1MB;
    protected float correnteSaida220F2MB;
    protected float correnteSaida220F1MR;
    protected float correnteSaida220F2MR;
    protected float correnteSaida110F1MB;
    protected float correnteSaida110F2MB;
    protected float correnteSaida110F1MR;
    protected float correnteSaida110F2MR;
    protected float potenciaAparenteOffset;
    protected float potenciaAparente220F1MR;
    protected float potenciaAparente220F2MR;
    protected float potenciaAparente220F1MB;
    protected float potenciaAparente220F2MB;
    protected float potenciaAparente110F1MR;
    protected float potenciaAparente110F2MR;
    protected float potenciaAparente110F1MB;
    protected float potenciaAparente110F2MB;
    protected float potenciaReal220F1MR;
    protected float potenciaReal220F2MR;
    protected float potenciaReal220F1MB;
    protected float potenciaReal220F2MB;
    protected float potenciaReal110F1MR;
    protected float potenciaReal110F2MR;
    protected float potenciaReal110F1MB;
    protected float potenciaReal110F2MB;
    protected float correnteEntradaF1MR;
    protected float correnteEntradaF2MR;
    protected float bateriaMaximoMR;
    protected float bateriaMinimoMR;
    protected float bateriaMaximoMB;
    protected float bateriaMinimoMB;
    protected int comparadorAutonomiaBateria;
    protected int comparadorContadorAutonomiaBaixa;
    protected int[] calcAut0100 = new int[]{1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 5, 5, 6, 7, 8, 10, 11, 12, 15, 17, 19, 22, 25, 28, 31, 35, 40, 43, 47, 52, 59, 64, 68, 75};
    protected int[] calcAut0200 = new int[]{1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 5, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 18, 20, 21, 24, 28, 30, 32, 33, 33, 34};
    protected int[] calcAut0300 = new int[]{1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 17, 19, 21, 22, 23};
    protected int[] calcAut0400 = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 3, 3, 4, 4, 4, 5, 6, 7, 7, 8, 9, 19, 11, 12, 13, 14, 16, 18, 20};
    protected int[] calcAut0500 = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 4, 5, 5, 6, 6, 6, 7, 7, 8, 8, 10, 11, 12, 13, 14};
    protected int[] calcAut0600 = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 5, 6, 6, 6, 7, 7, 8, 9, 10, 11, 12, 12, 12};
    protected int[] calcAut0700 = new int[]{1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 4, 4, 5, 5, 6, 6, 6, 7, 7, 8, 9, 10, 10, 10, 10, 10, 10};

    public SolisM11(ProtocoloUPS protocolo) {
        this.setProtocoloUPS(protocolo);
        protocolo.setModeloUPS(11);
        this.instanciaGlobais();
    }

    public SolisM11() {
        this.instanciaGlobais();
    }

    private void instanciaGlobais() {
        this.temperaturaCritica = 55.0f;
        this.potenciaNominalVA = 1000;
        this.potenciaNominalW = 1000;
        this.frequenciaEntradaC = 101715.0f;
        this.tensaoSaida220F1MB = 3.15f;
        this.tensaoSaida220F2MB = 2.0f;
        this.tensaoSaida220F1MR = 2.9f;
        this.tensaoSaida220F2MR = 13.0f;
        this.tensaoSaida110F1MB = 1.4f;
        this.tensaoSaida110F2MB = 18.0f;
        this.tensaoSaida110F1MR = 1.44f;
        this.tensaoSaida110F2MR = 13.0f;
        this.tensaoEntradaOffset = 30.0f;
        this.comparadorTensaoEntrada = 194;
        this.tensaoEntradaF1193 = 1.141f;
        this.tensaoEntradaF2193 = 12.0f;
        this.tensaoEntradaF1194 = 2.5f;
        this.tensaoEntradaF2194 = -250.0f;
        this.tensaoBateriaF1 = 0.13908206f;
        this.tensaoBateriaF2 = 0.6f;
        this.correnteSaida220F1MB = 0.020408163f;
        this.correnteSaida220F2MB = 0.1f;
        this.correnteSaida220F1MR = 0.020408163f;
        this.correnteSaida220F2MR = 0.1f;
        this.correnteSaida110F1MB = 0.04597701f;
        this.correnteSaida110F2MB = 0.15f;
        this.correnteSaida110F1MR = 0.04597701f;
        this.correnteSaida110F2MR = 0.15f;
        this.potenciaAparenteOffset = 28.0f;
        this.potenciaAparente220F1MR = 0.064935066f;
        this.potenciaAparente220F2MR = 22.0f;
        this.potenciaAparente220F1MB = 0.064935066f;
        this.potenciaAparente220F2MB = 22.0f;
        this.potenciaAparente110F1MR = 0.074074075f;
        this.potenciaAparente110F2MR = 16.0f;
        this.potenciaAparente110F1MB = 0.07751938f;
        this.potenciaAparente110F2MB = 17.0f;
        this.potenciaReal220F1MR = 0.06896552f;
        this.potenciaReal220F2MR = 20.0f;
        this.potenciaReal220F1MB = 0.071428575f;
        this.potenciaReal220F2MB = 25.0f;
        this.potenciaReal110F1MR = 0.07770008f;
        this.potenciaReal110F2MR = 15.6f;
        this.potenciaReal110F1MB = 0.08196721f;
        this.potenciaReal110F2MB = 13.0f;
        this.correnteEntradaF1MR = 22.2f;
        this.correnteEntradaF2MR = 800.0f;
        this.bateriaMaximoMR = 27.0f;
        this.bateriaMinimoMR = 23.0f;
        this.bateriaMaximoMB = 26.0f;
        this.bateriaMinimoMB = 21.0f;
        this.comparadorAutonomiaBateria = 5;
        this.comparadorContadorAutonomiaBaixa = 50;
    }

    @Override
    public boolean ligaEntrada() {
        return false;
    }

    @Override
    public boolean desligaEntrada() {
        return false;
    }

    @Override
    public boolean ligaSaida() {
        return false;
    }

    @Override
    public boolean desligaSaida() {
        return false;
    }

    @Override
    public boolean ativaBypass() {
        return false;
    }

    @Override
    public boolean desativaBypass() {
        return false;
    }

    @Override
    public boolean iniciarAutoteste() {
        return false;
    }

    @Override
    public boolean finalizarAutoteste() {
        return false;
    }

    @Override
    public boolean shutdown() {
        return this.protocoloUPS.shutdown();
    }

    @Override
    public boolean shutdownReligamento() {
        return this.protocoloUPS.shutdownReligamento();
    }

    @Override
    public void downloadEventos() {
        this.eventos = this.protocoloUPS.downloadEventos();
    }

    @Override
    public boolean configuraRelogio(int segundos, int minutos, int horas) {
        return this.protocoloUPS.configuraRelogio(segundos, minutos, horas);
    }

    @Override
    public boolean configuraCalendario(int diaSemana, int diaMes, int mes, int ano) {
        return this.protocoloUPS.configuraCalendario(diaSemana, diaMes, mes, ano);
    }

    @Override
    public boolean configuraCalendarioRelogio(int diaSemana, int diaMes, int mes, int ano, int segundo, int minuto, int hora) {
        return this.protocoloUPS.configuraCalendarioRelogio(diaSemana, diaMes, mes, ano, segundo, minuto, hora);
    }

    @Override
    public boolean programaSemana(boolean[] dias, int horaLigar, int minutoLigar, int horaDesligar, int minutoDesligar) {
        return this.protocoloUPS.programaSemana(dias, horaLigar, minutoLigar, horaDesligar, minutoDesligar);
    }

    @Override
    public boolean programa(boolean[] dias, int horaLigar, int minutoLigar, int horaDesligar, int minutoDesligar, int diaSemana, int diaMes, int mes, int ano, int segundo, int minuto, int hora) {
        return this.protocoloUPS.configuraCalendarioRelogioSemana(diaSemana, diaMes, mes, ano, segundo, minuto, hora, dias, horaLigar, minutoLigar, horaDesligar, minutoDesligar);
    }

    @Override
    public void addUPSListener(UPSListener ouvinteUPS) {
        this.ouvinteUPS = ouvinteUPS;
    }

    @Override
    public void notifica() {
        this.setModoRede(this.protocoloUPS.getModoRede());
        this.setTensaoEntrada220(this.protocoloUPS.isTensaoEntrada220());
        this.setTensaoEntradaNominal(this.protocoloUPS.getTensaoEntradaNominal());
        this.setTensaoEntrada(this.protocoloUPS.getTensaoEntrada());
        this.setTensaoBateria(this.protocoloUPS.getTensaoBateria());
        this.setTensaoSaida220(this.protocoloUPS.isTensaoSaida220());
        this.setPotenciaAparente(this.protocoloUPS.getPotenciaAparente());
        this.setCorrenteSaida(this.protocoloUPS.getCorrenteSaida());
        this.setModoBateria(this.protocoloUPS.getModoBateria());
        this.setTensaoSaida(this.protocoloUPS.getTensaoSaida());
        this.setCorrenteEntrada(this.protocoloUPS.getCorrenteEntrada());
        this.setFrequenciaEntrada(this.protocoloUPS.getFrequenciaEntrada());
        this.setLimiteInferiorTensaoEntrada(this.protocoloUPS.getLimiteInferiorTensaoEntrada());
        this.setLimiteSuperiorTensaoEntrada(this.protocoloUPS.getLimiteSuperiorTensaoEntrada());
        this.setTensaoSaidaNominal(this.protocoloUPS.getTensaoSaidaNominal());
        this.setFrequenciaSaida(this.protocoloUPS.getFrequenciaSaida());
        this.setLimiteInferiorTensaoSaida(this.protocoloUPS.getLimiteInferiorTensaoSaida());
        this.setLimiteSuperiorTensaoSaida(this.protocoloUPS.getLimiteSuperiorTensaoSaida());
        this.setPotenciaReal(this.protocoloUPS.getPotenciaReal());
        this.setFatorPotenciaCarga(this.protocoloUPS.getFatorPotenciaCarga());
        this.setTensaoBoost(this.protocoloUPS.getTensaoBoost());
        this.setTemperaturaUPS(this.protocoloUPS.getTemperaturaUPS());
        this.setPercentualBateria(this.protocoloUPS.getPercentualBateria());
        this.setAutonomiaBateria(this.protocoloUPS.getTensaoBateria());
        this.setCarregandoBateria(this.protocoloUPS.isCarregandoBateria());
        this.setUsandoSomenteBateria(this.protocoloUPS.isUsandoSomenteBateria());
        this.setModoBypass(this.protocoloUPS.isModoBypass());
        this.setSuperAquecimento(this.protocoloUPS.isSuperAquecimento());
        this.setTemperaturaElevada(this.protocoloUPS.isTemperaturaElevada());
        this.setBateriaBaixa(this.protocoloUPS.isBateriaBaixa());
        this.setBateriaCritica(this.protocoloUPS.isBateriaCritica());
        this.setCargaElevada(this.protocoloUPS.isCargaElevada());
        this.setBateriaDescarregada(this.protocoloUPS.isBateriaDescarregada());
        this.setBateriaCarregada(this.protocoloUPS.isBateriaCarregada());
        this.setSobrecarga(this.protocoloUPS.isSobrecarga());
        this.setSegundos(this.protocoloUPS.getSegundos());
        this.setMinutos(this.protocoloUPS.getMinutos());
        this.setHora(this.protocoloUPS.getHora());
        this.setDiaSemana(this.protocoloUPS.getDiaSemana());
        this.setDiaMes(this.protocoloUPS.getDiaMes());
        this.setMes(this.protocoloUPS.getMes());
        this.setAno(this.protocoloUPS.getAno());
        this.setDiasSemanaProgramados(this.protocoloUPS.getDiasSemanaProgramados());
        this.setMinutoLigar(this.protocoloUPS.getMinutoLigar());
        this.setHoraLigar(this.protocoloUPS.getHoraLigar());
        this.setMinutoDesligar(this.protocoloUPS.getMinutoDesligar());
        this.setHoraDesligar(this.protocoloUPS.getHoraDesligar());
        this.setSaidaLigada(this.protocoloUPS.isSaidaLigada());
        this.setEntradaLigada(this.protocoloUPS.isEntradaLigada());
        this.setBypassAtivado(this.protocoloUPS.isBypassAtivado());
        this.downloadEventos();
        this.ouvinteUPS.notificaControle();
    }

    public boolean setModoContinuo() {
        ProtocoloSolis protocoloSolis = (ProtocoloSolis)this.protocoloUPS;
        return protocoloSolis.setModoContinuo();
    }

    public boolean setModoEvento() {
        ProtocoloSolis protocoloSolis = (ProtocoloSolis)this.protocoloUPS;
        return protocoloSolis.setModoEvento();
    }

    @Override
    public void setAno(int ano) {
        this.ano = ano;
    }

    @Override
    public void setAutonomiaBateria(int tensaoBateriaBruta) {
        if (this.potenciaReal <= 20.0f) {
            this.autonomiaBateria = 170;
        } else if (this.potenciaReal > 20.0f && this.potenciaReal <= 150.0f) {
            try {
                this.autonomiaBateria = this.calcAut0100[tensaoBateriaBruta - 139];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (tensaoBateriaBruta > 176) {
                this.autonomiaBateria = 75;
            }
            if (tensaoBateriaBruta < 139) {
                this.autonomiaBateria = 0;
            }
        } else if (this.potenciaReal > 150.0f && this.potenciaReal <= 250.0f) {
            try {
                this.autonomiaBateria = this.calcAut0200[tensaoBateriaBruta - 139];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (tensaoBateriaBruta > 174) {
                this.autonomiaBateria = 34;
            }
            if (tensaoBateriaBruta < 139) {
                this.autonomiaBateria = 0;
            }
        } else if (this.potenciaReal > 250.0f && this.potenciaReal <= 350.0f) {
            try {
                this.autonomiaBateria = this.calcAut0300[tensaoBateriaBruta - 139];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (tensaoBateriaBruta > 172) {
                this.autonomiaBateria = 23;
            }
            if (tensaoBateriaBruta < 142) {
                this.autonomiaBateria = 0;
            }
        } else if (this.potenciaReal > 350.0f && this.potenciaReal <= 450.0f) {
            try {
                this.autonomiaBateria = this.calcAut0400[tensaoBateriaBruta - 139];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (tensaoBateriaBruta > 172) {
                this.autonomiaBateria = 20;
            }
            if (tensaoBateriaBruta < 141) {
                this.autonomiaBateria = 0;
            }
        } else if (this.potenciaReal > 450.0f && this.potenciaReal <= 550.0f) {
            try {
                this.autonomiaBateria = this.calcAut0500[tensaoBateriaBruta - 139];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (tensaoBateriaBruta > 170) {
                this.autonomiaBateria = 14;
            }
            if (tensaoBateriaBruta < 141) {
                this.autonomiaBateria = 0;
            }
        } else if (this.potenciaReal > 550.0f && this.potenciaReal <= 650.0f) {
            try {
                this.autonomiaBateria = this.calcAut0600[tensaoBateriaBruta - 139];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (tensaoBateriaBruta > 170) {
                this.autonomiaBateria = 12;
            }
            if (tensaoBateriaBruta < 141) {
                this.autonomiaBateria = 0;
            }
        } else if (this.potenciaReal > 650.0f) {
            try {
                this.autonomiaBateria = this.calcAut0700[tensaoBateriaBruta - 139];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (tensaoBateriaBruta > 170) {
                this.autonomiaBateria = 10;
            }
            if (tensaoBateriaBruta < 141) {
                this.autonomiaBateria = 0;
            }
        }
        if (this.expansorBateria > 0) {
            this.autonomiaBateria = this.autonomiaBateria * (this.expansorBateria + 14) / 14;
        }
    }

    @Override
    public void setBateriaBaixa(boolean bateriaBaixa) {
        this.contaAutonomiasBaixas = this.autonomiaBateria < this.comparadorAutonomiaBateria ? ++this.contaAutonomiasBaixas : 0;
        if (this.autonomiaBateria >= this.comparadorAutonomiaBateria) {
            this.bateriaBaixa = false;
        }
        this.bateriaBaixa = this.contaAutonomiasBaixas > this.comparadorContadorAutonomiaBaixa;
    }

    @Override
    public void setBateriaCarregada(boolean bateriaCarregada) {
        this.bateriaCarregada = this.modoRede && !this.carregandoBateria;
    }

    @Override
    public void setBateriaCritica(boolean bateriaCritica) {
        this.bateriaCritica = bateriaCritica;
    }

    @Override
    public void setUsandoSomenteBateria(boolean usandoSomenteBateria) {
        this.usandoSomenteBateria = !this.modoRede && this.modoBateria;
    }

    @Override
    public void setBateriaDescarregada(boolean bateriaDescarregada) {
    }

    @Override
    public void setBypassAtivado(boolean bypassAtivado) {
    }

    @Override
    public void setCargaElevada(boolean cargaElevada) {
        this.cargaElevada = (double)this.potenciaAparente > 1.2 * (double)this.potenciaNominalVA;
    }

    @Override
    public void setCarregandoBateria(boolean carregandoBateria) {
        this.carregandoBateria = carregandoBateria && this.modoRede;
    }

    @Override
    public void setCorrenteEntrada(int correnteEntrada) {
        this.correnteEntrada = !this.modoRede ? 0.0f : this.correnteEntradaF1MR / this.tensaoBateria - this.potenciaAparente / this.correnteEntradaF2MR + this.correnteSaida * (this.tensaoSaida / this.tensaoEntrada);
        if (this.tensaoEntrada < this.tensaoEntradaOffset) {
            this.correnteEntrada = 0.0f;
        }
    }

    @Override
    public void setCorrenteSaida(int correnteSaida) {
        this.correnteSaida = !this.modoRede ? (this.tensaoSaida220 ? (float)correnteSaida * this.correnteSaida220F1MB + this.correnteSaida220F2MB : (float)correnteSaida * this.correnteSaida110F1MB + this.correnteSaida110F2MB) : (this.tensaoSaida220 ? (float)correnteSaida * this.correnteSaida220F1MR + this.correnteSaida220F2MR : (float)correnteSaida * this.correnteSaida110F1MR + this.correnteSaida110F2MR);
        if (this.potenciaAparente < this.potenciaAparenteOffset) {
            this.correnteSaida = 0.0f;
        }
    }

    @Override
    public void setDiaMes(int diaMes) {
        this.diaMes = diaMes;
    }

    @Override
    public void setDiaSemana(int diaSemana) {
        this.diaSemana = diaSemana;
    }

    @Override
    public void setDiasSemanaProgramados(boolean[] diasSemanaProgramados) {
        this.diasSemanaProgramados = diasSemanaProgramados;
    }

    @Override
    public void setEntradaLigada(boolean entradaLigada) {
        this.entradaLigada = this.tensaoEntrada > 0.0f;
    }

    @Override
    public void setExpansorBateria(int expansorBateria) {
        this.expansorBateria = expansorBateria;
    }

    @Override
    public void setFatorPotenciaCarga(int fatorPotenciaCarga) {
        if (this.potenciaAparente <= 0.0f) {
            this.fatorPotenciaCarga = 0.0f;
        } else {
            try {
                this.fatorPotenciaCarga = (int)(this.potenciaReal / this.potenciaAparente * 100.0f);
                if (this.fatorPotenciaCarga > 100.0f) {
                    this.fatorPotenciaCarga = 100.0f;
                }
                this.fatorPotenciaCarga /= 100.0f;
            }
            catch (Exception e) {
                this.fatorPotenciaCarga = 100.0f;
                this.fatorPotenciaCarga /= 100.0f;
            }
        }
        if (this.potenciaAparente < this.potenciaAparenteOffset) {
            fatorPotenciaCarga = 0;
        }
    }

    @Override
    public void setFrequenciaEntrada(int frequenciaEntrada) {
        try {
            this.frequenciaEntrada = this.frequenciaEntradaC / (float)frequenciaEntrada;
        }
        catch (Exception e) {
            this.frequenciaEntrada = 0.0f;
        }
        if (this.tensaoEntrada < this.tensaoEntradaOffset) {
            this.frequenciaEntrada = 0.0f;
        }
    }

    @Override
    public void setFrequenciaSaida(int frequenciaSaida) {
        if (!this.modoBateria) {
            this.frequenciaSaida = 0.0f;
        }
        if (this.modoRede && this.modoBateria) {
            this.frequenciaSaida = this.frequenciaEntrada;
        }
    }

    @Override
    public void setHora(int hora) {
        this.hora = hora;
    }

    @Override
    public void setHoraDesligar(int horaDesligar) {
        this.horaDesligar = horaDesligar;
    }

    @Override
    public void setHoraLigar(int horaLigar) {
        this.horaLigar = horaLigar;
    }

    @Override
    public void setLimiteInferiorTensaoEntrada(int limiteInferiorTensaoEntrada) {
        this.limiteInferiorTensaoEntrada = this.tensaoEntrada > 180.0f ? 150.0f : 75.0f;
    }

    @Override
    public void setLimiteInferiorTensaoSaida(int limiteInferiorTensaoSaida) {
        this.limiteInferiorTensaoSaida = this.tensaoSaida220 ? 190.0f : 100.0f;
    }

    @Override
    public void setLimiteSuperiorTensaoEntrada(int limiteSuperiorTensaoEntrada) {
        this.limiteSuperiorTensaoEntrada = this.tensaoEntrada > 180.0f ? 300.0f : 150.0f;
    }

    @Override
    public void setLimiteSuperiorTensaoSaida(int limiteSuperiorTensaoSaida) {
        this.limiteSuperiorTensaoSaida = this.tensaoSaida220 ? 250.0f : 140.0f;
    }

    @Override
    public void setMes(int mes) {
        this.mes = mes;
    }

    @Override
    public void setMinutoDesligar(int minutoDesligar) {
        this.minutoDesligar = minutoDesligar;
    }

    @Override
    public void setMinutoLigar(int minutoLigar) {
        this.minutoLigar = minutoLigar;
    }

    @Override
    public void setMinutos(int minutos) {
        this.minutos = minutos;
    }

    @Override
    public void setModoBateria(boolean modoBateria) {
        this.modoBateria = modoBateria;
    }

    @Override
    public void setModoBypass(boolean modoBypass) {
        this.modoBypass = false;
    }

    @Override
    public void setModoRede(boolean modoRede) {
        this.modoRede = modoRede;
    }

    @Override
    public void setPercentualBateria(int percentualBateria) {
        this.percentualBateria = !this.modoRede ? (int)((this.tensaoBateria - this.bateriaMinimoMB) * (100.0f / (this.bateriaMaximoMB - this.bateriaMinimoMB))) : (int)((this.tensaoBateria - this.bateriaMinimoMR) * (100.0f / (this.bateriaMaximoMR - this.bateriaMinimoMR)));
        if (this.percentualBateria < 0) {
            this.percentualBateria = 0;
        }
        if (this.percentualBateria > 100) {
            this.percentualBateria = this.percentualBateria > 200 ? 0 : 100;
        }
    }

    @Override
    public void setPotenciaAparente(int potenciaAparente) {
        int correnteSaidaBruta = this.protocoloUPS.getCorrenteSaida();
        int tensaoSaidaBruta = this.protocoloUPS.getTensaoSaida();
        this.potenciaAparente = !this.modoRede ? (this.tensaoSaida220 ? (float)(correnteSaidaBruta * tensaoSaidaBruta) * this.potenciaAparente220F1MB + this.potenciaAparente220F2MB : (float)(correnteSaidaBruta * tensaoSaidaBruta) * this.potenciaAparente110F1MB + this.potenciaAparente110F2MB) : (this.tensaoSaida220 ? (float)(correnteSaidaBruta * tensaoSaidaBruta) * this.potenciaAparente220F1MR + this.potenciaAparente220F2MR : (float)(correnteSaidaBruta * tensaoSaidaBruta) * this.potenciaAparente110F1MR + this.potenciaAparente110F2MR);
        if (this.potenciaAparente < this.potenciaAparenteOffset) {
            this.potenciaAparente = 0.0f;
        }
    }

    @Override
    public void setPotenciaReal(int potenciaReal) {
        this.potenciaReal = !this.modoRede ? (this.tensaoSaida220 ? (float)potenciaReal * this.potenciaReal220F1MB + this.potenciaReal220F2MB : (float)potenciaReal * this.potenciaReal110F1MB + this.potenciaReal110F2MB) : (this.tensaoSaida220 ? (float)potenciaReal * this.potenciaReal220F1MR + this.potenciaReal220F2MR : (float)potenciaReal * this.potenciaReal110F1MR + this.potenciaReal110F2MR);
        if (this.potenciaAparente < this.potenciaAparenteOffset) {
            this.potenciaReal = 0.0f;
        }
    }

    @Override
    public void setSaidaLigada(boolean saidaLigada) {
        this.saidaLigada = this.modoBateria;
    }

    @Override
    public void setSegundos(int segundos) {
        this.segundos = segundos;
    }

    @Override
    public void setSobrecarga(boolean sobrecarga) {
        this.sobrecarga = sobrecarga;
    }

    @Override
    public void setSuperAquecimento(boolean superAquecimento) {
        this.superAquecimento = superAquecimento;
    }

    @Override
    public void setTemperaturaElevada(boolean temperaturaElevada) {
        this.temperaturaElevada = this.temperaturaUPS > this.temperaturaCritica;
    }

    @Override
    public void setTemperaturaUPS(int temperaturaUPS) {
        this.temperaturaUPS = temperaturaUPS;
    }

    @Override
    public void setTensaoBateria(int tensaoBateria) {
        this.tensaoBateria = (float)tensaoBateria * this.tensaoBateriaF1 + this.tensaoBateriaF2;
    }

    @Override
    public void setTensaoBoost(int tensaoBoost) {
    }

    @Override
    public void setTensaoEntrada(int tensaoEntrada) {
        this.tensaoEntrada = tensaoEntrada >= this.comparadorTensaoEntrada ? (float)tensaoEntrada * this.tensaoEntradaF1194 + this.tensaoEntradaF2194 : (float)tensaoEntrada * this.tensaoEntradaF1193 + this.tensaoEntradaF2193;
        if (this.tensaoEntrada < this.tensaoEntradaOffset) {
            this.tensaoEntrada = 0.0f;
        }
    }

    @Override
    public void setTensaoEntradaNominal(int tensaoEntradaNominal) {
        if (this.modoRede) {
            this.tensaoEntradaNominal = this.tensaoEntrada > 180.0f ? 220.0f : 110.0f;
        }
    }

    @Override
    public void setTensaoEntrada220(boolean tensaoEntrada220) {
        this.tensaoEntrada220 = tensaoEntrada220;
    }

    @Override
    public void setTensaoSaida(int tensaoSaida) {
        this.tensaoSaida = !this.modoRede ? (this.tensaoSaida220 ? (float)tensaoSaida * this.tensaoSaida220F1MB + this.tensaoSaida220F2MB : (float)tensaoSaida * this.tensaoSaida110F1MB + this.tensaoSaida110F2MB) : (this.tensaoSaida220 ? (float)tensaoSaida * this.tensaoSaida220F1MR + this.tensaoSaida220F2MR : (float)tensaoSaida * this.tensaoSaida110F1MR + this.tensaoSaida110F2MR);
        if (!this.modoBateria) {
            this.tensaoSaida = 0.0f;
        }
    }

    @Override
    public void setTensaoSaidaNominal(int tensaoSaidaNominal) {
        this.tensaoSaidaNominal = this.tensaoSaida220 ? 220.0f : 110.0f;
    }

    @Override
    public void setTensaoSaida220(boolean tensaoSaida220) {
        this.tensaoSaida220 = tensaoSaida220;
    }

    @Override
    public void setFatorPotenciaEquipamento(int fatorPotenciaEquipamento) {
        this.fatorPotenciaEquipamento = fatorPotenciaEquipamento;
    }

    @Override
    public void setTemperaturaCritica(int temperaturaCritica) {
        this.temperaturaCritica = temperaturaCritica;
    }

    @Override
    public void setPotenciaNominalVA(int potenciaNominalVA) {
        this.potenciaNominalVA = potenciaNominalVA;
    }

    @Override
    public void setPotenciaNominalW(int potenciaNominalW) {
        this.potenciaNominalW = potenciaNominalW;
    }

    @Override
    public void setBateriaTensaoNominal(int bateriaTensaoNominal) {
        this.bateriaTensaoNominal = bateriaTensaoNominal;
    }

    public void setBateriaMaximoMB(float bateriaMaximoMB) {
        this.bateriaMaximoMB = bateriaMaximoMB;
    }

    public void setBateriaMaximoMR(float bateriaMaximoMR) {
        this.bateriaMaximoMR = bateriaMaximoMR;
    }

    public void setBateriaMinimoMB(float bateriaMinimoMB) {
        this.bateriaMinimoMB = bateriaMinimoMB;
    }

    public void setBateriaMinimoMR(float bateriaMinimoMR) {
        this.bateriaMinimoMR = bateriaMinimoMR;
    }

    public void setCalcAut0100(int[] calcAut0100) {
        this.calcAut0100 = calcAut0100;
    }

    public void setCalcAut0200(int[] calcAut0200) {
        this.calcAut0200 = calcAut0200;
    }

    public void setCalcAut0300(int[] calcAut0300) {
        this.calcAut0300 = calcAut0300;
    }

    public void setCalcAut0400(int[] calcAut0400) {
        this.calcAut0400 = calcAut0400;
    }

    public void setCalcAut0500(int[] calcAut0500) {
        this.calcAut0500 = calcAut0500;
    }

    public void setCalcAut0600(int[] calcAut0600) {
        this.calcAut0600 = calcAut0600;
    }

    public void setCalcAut0700(int[] calcAut0700) {
        this.calcAut0700 = calcAut0700;
    }

    public void setCorrenteEntradaF1MR(float correnteEntradaF1MR) {
        this.correnteEntradaF1MR = correnteEntradaF1MR;
    }

    public void setCorrenteEntradaF2MR(float correnteEntradaF2MR) {
        this.correnteEntradaF2MR = correnteEntradaF2MR;
    }

    public void setCorrenteSaida110F1MB(float correnteSaida110F1MB) {
        this.correnteSaida110F1MB = correnteSaida110F1MB;
    }

    public void setCorrenteSaida110F1MR(float correnteSaida110F1MR) {
        this.correnteSaida110F1MR = correnteSaida110F1MR;
    }

    public void setCorrenteSaida110F2MB(float correnteSaida110F2MB) {
        this.correnteSaida110F2MB = correnteSaida110F2MB;
    }

    public void setCorrenteSaida110F2MR(float correnteSaida110F2MR) {
        this.correnteSaida110F2MR = correnteSaida110F2MR;
    }

    public void setCorrenteSaida220F1MB(float correnteSaida220F1MB) {
        this.correnteSaida220F1MB = correnteSaida220F1MB;
    }

    public void setCorrenteSaida220F1MR(float correnteSaida220F1MR) {
        this.correnteSaida220F1MR = correnteSaida220F1MR;
    }

    public void setCorrenteSaida220F2MB(float correnteSaida220F2MB) {
        this.correnteSaida220F2MB = correnteSaida220F2MB;
    }

    public void setCorrenteSaida220F2MR(float correnteSaida220F2MR) {
        this.correnteSaida220F2MR = correnteSaida220F2MR;
    }

    public void setFrequenciaEntrada(float frequenciaEntrada) {
        this.frequenciaEntrada = frequenciaEntrada;
    }

    public void setPotenciaAparente110F1MB(float potenciaAparente110F1MB) {
        this.potenciaAparente110F1MB = potenciaAparente110F1MB;
    }

    public void setPotenciaAparente110F1MR(float potenciaAparente110F1MR) {
        this.potenciaAparente110F1MR = potenciaAparente110F1MR;
    }

    public void setPotenciaAparente110F2MB(float potenciaAparente110F2MB) {
        this.potenciaAparente110F2MB = potenciaAparente110F2MB;
    }

    public void setPotenciaAparente110F2MR(float potenciaAparente110F2MR) {
        this.potenciaAparente110F2MR = potenciaAparente110F2MR;
    }

    public void setPotenciaAparente220F1MB(float potenciaAparente220F1MB) {
        this.potenciaAparente220F1MB = potenciaAparente220F1MB;
    }

    public void setPotenciaAparente220F1MR(float potenciaAparente220F1MR) {
        this.potenciaAparente220F1MR = potenciaAparente220F1MR;
    }

    public void setPotenciaAparente220F2MB(float potenciaAparente220F2MB) {
        this.potenciaAparente220F2MB = potenciaAparente220F2MB;
    }

    public void setPotenciaAparente220F2MR(float potenciaAparente220F2MR) {
        this.potenciaAparente220F2MR = potenciaAparente220F2MR;
    }

    public void setPotenciaAparenteOffset(float potenciaAparenteOffset) {
        this.potenciaAparenteOffset = potenciaAparenteOffset;
    }

    public void setPotenciaReal110F1MB(float potenciaReal110F1MB) {
        this.potenciaReal110F1MB = potenciaReal110F1MB;
    }

    public void setPotenciaReal110F1MR(float potenciaReal110F1MR) {
        this.potenciaReal110F1MR = potenciaReal110F1MR;
    }

    public void setPotenciaReal110F2MB(float potenciaReal110F2MB) {
        this.potenciaReal110F2MB = potenciaReal110F2MB;
    }

    public void setPotenciaReal110F2MR(float potenciaReal110F2MR) {
        this.potenciaReal110F2MR = potenciaReal110F2MR;
    }

    public void setPotenciaReal220F1MB(float potenciaReal220F1MB) {
        this.potenciaReal220F1MB = potenciaReal220F1MB;
    }

    public void setPotenciaReal220F1MR(float potenciaReal220F1MR) {
        this.potenciaReal220F1MR = potenciaReal220F1MR;
    }

    public void setPotenciaReal220F2MB(float potenciaReal220F2MB) {
        this.potenciaReal220F2MB = potenciaReal220F2MB;
    }

    public void setPotenciaReal220F2MR(float potenciaReal220F2MR) {
        this.potenciaReal220F2MR = potenciaReal220F2MR;
    }

    public void setTensaoBateriaF1(float tensaoBateriaF1) {
        this.tensaoBateriaF1 = tensaoBateriaF1;
    }

    public void setTensaoBateriaF2(float tensaoBateriaF2) {
        this.tensaoBateriaF2 = tensaoBateriaF2;
    }

    public void setTensaoEntradaF1193(float tensaoEntradaF1193) {
        this.tensaoEntradaF1193 = tensaoEntradaF1193;
    }

    public void setTensaoEntradaF1194(float tensaoEntradaF1194) {
        this.tensaoEntradaF1194 = tensaoEntradaF1194;
    }

    public void setTensaoEntradaF2193(float tensaoEntradaF2193) {
        this.tensaoEntradaF2193 = tensaoEntradaF2193;
    }

    public void setTensaoEntradaF2194(float tensaoEntradaF2194) {
        this.tensaoEntradaF2194 = tensaoEntradaF2194;
    }

    public void setTensaoEntradaOffset(float tensaoEntradaOffset) {
        this.tensaoEntradaOffset = tensaoEntradaOffset;
    }

    public void setTensaoSaida110F1MB(float tensaoSaida110F1MB) {
        this.tensaoSaida110F1MB = tensaoSaida110F1MB;
    }

    public void setTensaoSaida110F1MR(float tensaoSaida110F1MR) {
        this.tensaoSaida110F1MR = tensaoSaida110F1MR;
    }

    public void setTensaoSaida110F2MB(float tensaoSaida110F2MB) {
        this.tensaoSaida110F2MB = tensaoSaida110F2MB;
    }

    public void setTensaoSaida110F2MR(float tensaoSaida110F2MR) {
        this.tensaoSaida110F2MR = tensaoSaida110F2MR;
    }

    public void setTensaoSaida220F1MB(float tensaoSaida220F1MB) {
        this.tensaoSaida220F1MB = tensaoSaida220F1MB;
    }

    public void setTensaoSaida220F1MR(float tensaoSaida220F1MR) {
        this.tensaoSaida220F1MR = tensaoSaida220F1MR;
    }

    public void setTensaoSaida220F2MB(float tensaoSaida220F2MB) {
        this.tensaoSaida220F2MB = tensaoSaida220F2MB;
    }

    public void setTensaoSaida220F2MR(float tensaoSaida220F2MR) {
        this.tensaoSaida220F2MR = tensaoSaida220F2MR;
    }

    public void setComparadorTensaoEntrada(int comparadorTensaoEntrada) {
        this.comparadorTensaoEntrada = comparadorTensaoEntrada;
    }

    public void setComparadorAutonomiaBateria(int comparadorAutonomiaBateria) {
        this.comparadorAutonomiaBateria = comparadorAutonomiaBateria;
    }

    public void setComparadorContadorAutonomiaBaixa(int comparadorContadorAutonomiaBaixa) {
        this.comparadorContadorAutonomiaBaixa = comparadorContadorAutonomiaBaixa;
    }
}

