/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.dispositivos;

import br.com.schneider.sgm.dispositivos.SolisM11;
import br.com.schneider.sgm.protocolo.ProtocoloUPS;

public class SolisLI700
extends SolisM11 {
    protected int[] calcAut0100 = new int[]{1, 1, 1, 2, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 17, 19, 22, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24};
    protected int[] calcAut0200 = new int[]{1, 1, 1, 1, 2, 3, 3, 4, 4, 5, 5, 6, 7, 8, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10};
    protected int[] calcAut0300 = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 3, 3, 4, 5, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    protected int[] calcAut0400 = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5};
    protected int[] calcAut0500 = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};

    public SolisLI700(ProtocoloUPS protocolo) {
        this.setProtocoloUPS(protocolo);
        protocolo.setModeloUPS(9);
        this.instanciaGlobais();
    }

    private void instanciaGlobais() {
        this.temperaturaCritica = 100.0f;
        this.potenciaNominalVA = 700;
        this.potenciaNominalW = 500;
        this.frequenciaEntradaC = 101580.0f;
        this.tensaoSaida220F1MB = 3.15f;
        this.tensaoSaida220F2MB = 2.0f;
        this.tensaoSaida220F1MR = 2.9f;
        this.tensaoSaida220F2MR = 13.0f;
        this.tensaoSaida110F1MB = 1.428f;
        this.tensaoSaida110F2MB = 12.8f;
        this.tensaoSaida110F1MR = 1.428f;
        this.tensaoSaida110F2MR = 12.8f;
        this.tensaoEntradaOffset = 30.0f;
        this.comparadorTensaoEntrada = 106;
        this.tensaoEntradaF1193 = 1.3f;
        this.tensaoEntradaF2193 = 19.5f;
        this.tensaoEntradaF1194 = 1.25f;
        this.tensaoEntradaF2194 = 27.5f;
        this.tensaoBateriaF1 = 0.155f;
        this.tensaoBateriaF2 = 0.105f;
        this.correnteSaida220F1MB = 0.16051364f;
        this.correnteSaida220F2MB = 0.67f;
        this.correnteSaida220F1MR = 0.15360983f;
        this.correnteSaida220F2MR = 0.7f;
        this.correnteSaida110F1MB = 0.16051364f;
        this.correnteSaida110F2MB = 0.67f;
        this.correnteSaida110F1MR = 0.15360983f;
        this.correnteSaida110F2MR = 0.7f;
        this.potenciaAparenteOffset = 55.0f;
        this.potenciaAparente220F1MR = 0.26f;
        this.potenciaAparente220F2MR = 13.7f;
        this.potenciaAparente220F1MB = 0.064935066f;
        this.potenciaAparente220F2MB = 22.0f;
        this.potenciaAparente110F1MR = this.correnteSaida110F1MR * this.tensaoSaida110F1MR;
        this.potenciaAparente110F2MR = this.correnteSaida110F2MR + this.tensaoSaida110F2MR;
        this.potenciaAparente110F1MB = this.correnteSaida110F1MB * this.tensaoSaida110F1MB;
        this.potenciaAparente110F2MB = this.correnteSaida110F2MB + this.tensaoSaida110F2MB;
        this.potenciaReal220F1MR = 0.26f;
        this.potenciaReal220F2MR = 70.0f;
        this.potenciaReal220F1MB = 0.27f;
        this.potenciaReal220F2MB = 71.0f;
        this.potenciaReal110F1MR = 0.26f;
        this.potenciaReal110F2MR = 70.0f;
        this.potenciaReal110F1MB = 0.27f;
        this.potenciaReal110F2MB = 71.0f;
        this.correnteEntradaF1MR = 22.2f;
        this.correnteEntradaF2MR = 800.0f;
        this.bateriaMaximoMR = 27.0f;
        this.bateriaMinimoMR = 23.0f;
        this.bateriaMaximoMB = 26.0f;
        this.bateriaMinimoMB = 21.0f;
        this.comparadorAutonomiaBateria = 5;
        this.comparadorContadorAutonomiaBaixa = 50;
    }

    @Override
    public void setLimiteInferiorTensaoEntrada(int limiteInferiorTensaoEntrada) {
        this.limiteInferiorTensaoEntrada = this.tensaoEntrada > 160.0f ? 160.0f : 75.0f;
    }

    @Override
    public void setLimiteSuperiorTensaoEntrada(int limiteSuperiorTensaoEntrada) {
        this.limiteSuperiorTensaoEntrada = this.tensaoEntrada > 180.0f ? 300.0f : 160.0f;
    }

    @Override
    public void setFrequenciaEntrada(int frequenciaEntrada) {
        if (this.modoBateria) {
            try {
                this.frequenciaEntrada = this.frequenciaEntradaC / (float)frequenciaEntrada;
            }
            catch (Exception e) {
                this.frequenciaEntrada = 0.0f;
            }
        } else {
            try {
                this.frequenciaEntrada = this.frequenciaEntradaC / (float)frequenciaEntrada - 0.8f;
            }
            catch (Exception e) {
                this.frequenciaEntrada = 0.0f;
            }
        }
        if (this.tensaoEntrada < this.tensaoEntradaOffset) {
            this.frequenciaEntrada = 0.0f;
        }
    }

    @Override
    public void setPotenciaAparente(int potenciaAparente) {
        this.potenciaAparente = this.correnteSaida * this.tensaoSaida;
        if (this.potenciaAparente == this.potenciaAparenteOffset) {
            this.potenciaAparente = 0.0f;
        }
    }

    @Override
    public void setCorrenteSaida(int correnteSaida) {
        this.correnteSaida = !this.modoRede ? (this.tensaoSaida220 ? (float)correnteSaida * this.correnteSaida220F1MB + this.correnteSaida220F2MB : (float)correnteSaida * this.correnteSaida110F1MB + this.correnteSaida110F2MB) : (this.tensaoSaida220 ? (float)correnteSaida * this.correnteSaida220F1MR + this.correnteSaida220F2MR : (float)correnteSaida * this.correnteSaida110F1MR + this.correnteSaida110F2MR);
        if (correnteSaida == 0) {
            this.correnteSaida = 0.0f;
        }
    }

    @Override
    public void setAutonomiaBateria(int tensaoBateriaBruta) {
        if (this.potenciaReal <= 20.0f) {
            this.autonomiaBateria = 170;
        } else if (this.potenciaReal > 20.0f && this.potenciaReal <= 150.0f) {
            try {
                this.autonomiaBateria = this.calcAut0100[tensaoBateriaBruta - 136];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (tensaoBateriaBruta > 156) {
                this.autonomiaBateria = 24;
            }
            if (tensaoBateriaBruta < 136) {
                this.autonomiaBateria = 0;
            }
        } else if (this.potenciaReal > 150.0f && this.potenciaReal <= 250.0f) {
            try {
                this.autonomiaBateria = this.calcAut0200[tensaoBateriaBruta - 136];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (tensaoBateriaBruta > 154) {
                this.autonomiaBateria = 10;
            }
            if (tensaoBateriaBruta < 136) {
                this.autonomiaBateria = 0;
            }
        } else if (this.potenciaReal > 250.0f && this.potenciaReal <= 350.0f) {
            try {
                this.autonomiaBateria = this.calcAut0300[tensaoBateriaBruta - 136];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (tensaoBateriaBruta > 156) {
                this.autonomiaBateria = 7;
            }
            if (tensaoBateriaBruta < 136) {
                this.autonomiaBateria = 0;
            }
        } else if (this.potenciaReal > 350.0f && this.potenciaReal <= 450.0f) {
            try {
                this.autonomiaBateria = this.calcAut0400[tensaoBateriaBruta - 136];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (tensaoBateriaBruta > 155) {
                this.autonomiaBateria = 5;
            }
            if (tensaoBateriaBruta < 136) {
                this.autonomiaBateria = 0;
            }
        } else if (this.potenciaReal > 450.0f && this.potenciaReal <= 550.0f) {
            try {
                this.autonomiaBateria = this.calcAut0500[tensaoBateriaBruta - 136];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (tensaoBateriaBruta > 149) {
                this.autonomiaBateria = 3;
            }
            if (tensaoBateriaBruta < 136) {
                this.autonomiaBateria = 0;
            }
        }
        if (this.expansorBateria > 0) {
            this.autonomiaBateria = this.autonomiaBateria * (this.expansorBateria + 14) / 14;
        }
    }

    @Override
    public boolean isTemperaturaAvaliable() {
        return false;
    }
}

