/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.dispositivos;

import br.com.schneider.sgm.dispositivos.SolisM11;
import br.com.schneider.sgm.eventos.Evento;
import br.com.schneider.sgm.protocolo.ProtocoloSolis;
import br.com.schneider.sgm.protocolo.ProtocoloUPS;
import java.util.GregorianCalendar;

public class SolisDCM15
extends SolisM11 {
    private int cntSobreTemperatura;
    protected int[] calcAut0100 = new int[]{1, 1, 1, 1, 2, 2, 2, 3, 4, 5, 5, 8, 10, 11, 13, 15, 18, 22, 24, 28, 34, 40, 43, 48, 56, 65, 70, 76, 85, 93, 100, 110, 122, 132, 141, 152, 162};
    protected int[] calcAut0200 = new int[]{1, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 5, 6, 8, 9, 10, 12, 15, 18, 20, 22, 25, 30, 35, 40, 44, 48, 54, 60, 65, 73, 80, 85, 92, 94, 95};
    protected int[] calcAut0300 = new int[]{1, 1, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 6, 8, 10, 14, 16, 18, 20, 24, 30, 32, 36, 40, 44, 48, 52, 54, 58, 59, 60, 62, 62, 62};
    protected int[] calcAut0400 = new int[]{1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 3, 3, 4, 4, 5, 5, 6, 8, 9, 10, 12, 13, 15, 17, 20, 22, 24, 28, 32, 35, 38, 42};
    protected int[] calcAut0500 = new int[]{1, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 4, 4, 5, 5, 6, 7, 8, 10, 11, 12, 14, 15, 17, 18, 21, 24, 26, 29, 32, 34, 36};
    protected int[] calcAut0600 = new int[]{1, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 5, 5, 6, 7, 8, 9, 10, 12, 13, 15, 16, 18, 20, 22, 24, 26, 28};
    protected int[] calcAut0700 = new int[]{1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 9, 10, 11, 13, 14, 15, 17, 19, 21, 22};
    protected int[] calcAut0800 = new int[]{1, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 11, 12, 14, 15, 17, 18, 19, 20, 20};
    protected int[] calcAut0900 = new int[]{1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 5, 6, 6, 7, 7, 8, 9, 10, 11, 12, 13, 15, 15, 16, 16, 16};
    protected int[] calcAut1000 = new int[]{1, 1, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 6, 7, 8, 9, 9, 10, 11, 12, 12, 12, 13, 13, 14, 14, 14};
    protected int[] calcAut1100 = new int[]{1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 3, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 9, 10, 10, 10, 11, 11, 12, 12, 12};
    protected int[] calcAut1200 = new int[]{1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 8, 9, 9, 10, 10, 10};
    protected int[] calcAut1300 = new int[]{1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8};

    public SolisDCM15(ProtocoloUPS protocolo) {
        super(protocolo);
        int modelo = 0xF & protocolo.getCabecalhoPacote();
        protocolo.setModeloUPS(modelo);
        this.instanciaGlobais();
    }

    public SolisDCM15() {
    }

    private void instanciaGlobais() {
        this.frequenciaEntradaC = 101700.0f;
        this.tensaoSaida220F1MB = 3.0f;
        this.tensaoSaida220F2MB = 12.0f;
        this.tensaoSaida220F1MR = 2.93f;
        this.tensaoSaida220F2MR = 13.0f;
        this.tensaoSaida110F1MB = 1.465f;
        this.tensaoSaida110F2MB = 16.0f;
        this.tensaoSaida110F1MR = 1.465f;
        this.tensaoSaida110F2MR = 12.0f;
        this.tensaoEntradaOffset = 50.0f;
        this.comparadorTensaoEntrada = 194;
        this.tensaoEntradaF1193 = 2.1417f;
        this.tensaoEntradaF2193 = 23.09f;
        this.tensaoEntradaF1194 = 2.1417f;
        this.tensaoEntradaF2194 = 23.09f;
        this.tensaoBateriaF1 = 0.4286f;
        this.tensaoBateriaF2 = 5.5714f;
        this.correnteSaida220F1MB = 0.08237232f;
        this.correnteSaida220F2MB = 0.382f;
        this.correnteSaida220F1MR = 0.08237232f;
        this.correnteSaida220F2MR = 0.382f;
        this.correnteSaida110F1MB = 0.08620689f;
        this.correnteSaida110F2MB = 0.1f;
        this.correnteSaida110F1MR = 0.08620689f;
        this.correnteSaida110F2MR = 0.1f;
        this.potenciaAparenteOffset = 100.0f;
        this.potenciaAparente220F1MR = 0.0f;
        this.potenciaAparente220F2MR = 0.0f;
        this.potenciaAparente220F1MB = 0.0f;
        this.potenciaAparente220F2MB = 0.0f;
        this.potenciaAparente110F1MR = 0.0f;
        this.potenciaAparente110F2MR = 0.0f;
        this.potenciaAparente110F1MB = 0.0f;
        this.potenciaAparente110F2MB = 0.0f;
        this.potenciaReal220F1MR = 0.2378f;
        this.potenciaReal220F2MR = 178.1f;
        this.potenciaReal220F1MB = 0.2664f;
        this.potenciaReal220F2MB = 148.45f;
        this.potenciaReal110F1MR = 0.1227f;
        this.potenciaReal110F2MR = 68.906f;
        this.potenciaReal110F1MB = 0.1367f;
        this.potenciaReal110F2MB = 52.747f;
        this.correnteEntradaF1MR = 0.0f;
        this.correnteEntradaF2MR = 0.0f;
        this.bateriaMaximoMR = 84.0f;
        this.bateriaMinimoMR = 63.0f;
        this.bateriaMaximoMB = 84.0f;
        this.bateriaMinimoMB = 63.0f;
        this.comparadorAutonomiaBateria = 5;
        this.comparadorContadorAutonomiaBaixa = 50;
    }

    @Override
    public void setAutonomiaBateria(int tensaoBateriaBruta) {
        if (this.potenciaReal <= 20.0f) {
            this.autonomiaBateria = 170;
        } else if (this.potenciaReal > 20.0f && this.potenciaReal <= 150.0f) {
            try {
                this.autonomiaBateria = this.calcAut0100[tensaoBateriaBruta - 141];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (tensaoBateriaBruta > 177) {
                this.autonomiaBateria = 164;
            }
            if (tensaoBateriaBruta < 141) {
                this.autonomiaBateria = 0;
            }
        } else if (this.potenciaReal > 150.0f && this.potenciaReal <= 250.0f) {
            try {
                this.autonomiaBateria = this.calcAut0200[tensaoBateriaBruta - 141];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (tensaoBateriaBruta > 177) {
                this.autonomiaBateria = 95;
            }
            if (tensaoBateriaBruta < 141) {
                this.autonomiaBateria = 0;
            }
        } else if (this.potenciaReal > 250.0f && this.potenciaReal <= 350.0f) {
            try {
                this.autonomiaBateria = this.calcAut0300[tensaoBateriaBruta - 141];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (tensaoBateriaBruta > 177) {
                this.autonomiaBateria = 64;
            }
            if (tensaoBateriaBruta < 141) {
                this.autonomiaBateria = 0;
            }
        } else if (this.potenciaReal > 350.0f && this.potenciaReal <= 450.0f) {
            try {
                this.autonomiaBateria = this.calcAut0400[tensaoBateriaBruta - 141];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (tensaoBateriaBruta > 172) {
                this.autonomiaBateria = 44;
            }
            if (tensaoBateriaBruta < 141) {
                this.autonomiaBateria = 0;
            }
        } else if (this.potenciaReal > 450.0f && this.potenciaReal <= 550.0f) {
            try {
                this.autonomiaBateria = this.calcAut0500[tensaoBateriaBruta - 139];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (tensaoBateriaBruta > 170) {
                this.autonomiaBateria = 36;
            }
            if (tensaoBateriaBruta < 141) {
                this.autonomiaBateria = 0;
            }
        } else if (this.potenciaReal > 550.0f && this.potenciaReal <= 650.0f) {
            try {
                this.autonomiaBateria = this.calcAut0600[tensaoBateriaBruta - 141];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (tensaoBateriaBruta > 173) {
                this.autonomiaBateria = 28;
            }
            if (tensaoBateriaBruta < 141) {
                this.autonomiaBateria = 0;
            }
        } else if (this.potenciaReal > 750.0f && this.potenciaReal <= 650.0f) {
            try {
                this.autonomiaBateria = this.calcAut0700[tensaoBateriaBruta - 141];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (tensaoBateriaBruta > 172) {
                this.autonomiaBateria = 22;
            }
            if (tensaoBateriaBruta < 141) {
                this.autonomiaBateria = 0;
            }
        } else if (this.potenciaReal > 750.0f && this.potenciaReal <= 850.0f) {
            try {
                this.autonomiaBateria = this.calcAut0800[tensaoBateriaBruta - 141];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (tensaoBateriaBruta > 172) {
                this.autonomiaBateria = 20;
            }
            if (tensaoBateriaBruta < 141) {
                this.autonomiaBateria = 0;
            }
        } else if (this.potenciaReal > 850.0f && this.potenciaReal <= 950.0f) {
            try {
                this.autonomiaBateria = this.calcAut0900[tensaoBateriaBruta - 141];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (tensaoBateriaBruta > 172) {
                this.autonomiaBateria = 16;
            }
            if (tensaoBateriaBruta < 141) {
                this.autonomiaBateria = 0;
            }
        } else if (this.potenciaReal > 950.0f && this.potenciaReal <= 1050.0f) {
            try {
                this.autonomiaBateria = this.calcAut1000[tensaoBateriaBruta - 141];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (tensaoBateriaBruta > 172) {
                this.autonomiaBateria = 14;
            }
            if (tensaoBateriaBruta < 141) {
                this.autonomiaBateria = 0;
            }
        } else if (this.potenciaReal > 1050.0f && this.potenciaReal <= 1150.0f) {
            try {
                this.autonomiaBateria = this.calcAut1100[tensaoBateriaBruta - 141];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (tensaoBateriaBruta > 172) {
                this.autonomiaBateria = 22;
            }
            if (tensaoBateriaBruta < 141) {
                this.autonomiaBateria = 0;
            }
        } else if (this.potenciaReal > 1150.0f && this.potenciaReal <= 1250.0f) {
            try {
                this.autonomiaBateria = this.calcAut1200[tensaoBateriaBruta - 141];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (tensaoBateriaBruta > 172) {
                this.autonomiaBateria = 12;
            }
            if (tensaoBateriaBruta < 141) {
                this.autonomiaBateria = 0;
            }
        } else if (this.potenciaReal > 1250.0f) {
            try {
                this.autonomiaBateria = this.calcAut0600[tensaoBateriaBruta - 141];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (tensaoBateriaBruta > 172) {
                this.autonomiaBateria = 8;
            }
            if (tensaoBateriaBruta < 141) {
                this.autonomiaBateria = 0;
            }
        }
        if (this.expansorBateria > 0) {
            this.autonomiaBateria = this.autonomiaBateria * (this.expansorBateria + 14) / 14;
        }
        this.autonomiaBateria /= 2;
    }

    @Override
    public void notifica() {
        super.notifica();
        this.setModoBypass(this.protocoloUPS.isBypassAtivado());
    }

    @Override
    public void setTensaoSaida220(boolean tensaoSaida220) {
        this.tensaoSaida220 = !tensaoSaida220;
    }

    @Override
    public void setTensaoSaida(int tensaoSaida) {
        this.tensaoSaida = !this.modoRede ? (this.tensaoSaida220 ? 220.0f : 115.0f) : (this.tensaoSaida220 ? 220.0f : 115.0f);
        if (!this.modoBateria) {
            this.tensaoSaida = 0.0f;
        }
    }

    @Override
    public void setTensaoEntrada220(boolean tensaoEntrada220) {
        this.tensaoEntrada220 = this.tensaoEntrada > 180.0f;
    }

    @Override
    public void setTensaoEntradaNominal(int tensaoEntrada) {
        this.tensaoEntradaNominal = this.tensaoEntrada > 180.0f ? 220.0f : 115.0f;
    }

    @Override
    public void setTensaoEntrada(int tensaoEntrada) {
        this.tensaoEntrada = tensaoEntrada >= this.comparadorTensaoEntrada ? (float)tensaoEntrada * this.tensaoEntradaF1194 + this.tensaoEntradaF2194 : (float)tensaoEntrada * this.tensaoEntradaF1193 + this.tensaoEntradaF2193;
        if (this.tensaoEntrada < this.tensaoEntradaOffset) {
            this.tensaoEntrada = 0.0f;
        }
    }

    @Override
    public void setPotenciaReal(int potenciaReal) {
        this.potenciaReal = !this.modoRede ? (this.tensaoSaida220 ? (float)potenciaReal * this.potenciaReal220F1MB + this.potenciaReal220F2MB : (float)potenciaReal * this.potenciaReal110F1MB + this.potenciaReal110F2MB) : (this.tensaoSaida220 ? (float)potenciaReal * this.potenciaReal220F1MR + this.potenciaReal220F2MR : (float)potenciaReal * this.potenciaReal110F1MR + this.potenciaReal110F2MR);
        if ((float)potenciaReal < this.potenciaAparenteOffset) {
            this.potenciaReal = 0.0f;
        }
    }

    @Override
    public void setPotenciaAparente(int potenciaAparente) {
        this.potenciaAparente = 1.25f * this.potenciaReal;
        if (this.potenciaAparente < this.potenciaAparenteOffset) {
            this.potenciaAparente = 0.0f;
        }
    }

    @Override
    public void setCorrenteEntrada(int correnteEntrada) {
        this.correnteEntrada = !this.modoRede ? 0.0f : this.potenciaReal / this.tensaoEntrada;
        if (this.tensaoEntrada < this.tensaoEntradaOffset) {
            this.correnteEntrada = 0.0f;
        }
    }

    @Override
    public void setCorrenteSaida(int correnteSaida) {
        this.correnteSaida = !this.modoRede ? (this.tensaoSaida220 ? (float)correnteSaida * this.correnteSaida220F1MB + this.correnteSaida220F2MB : (float)correnteSaida * this.correnteSaida110F1MB + this.correnteSaida110F2MB) : (this.tensaoSaida220 ? (float)correnteSaida * this.correnteSaida220F1MR + this.correnteSaida220F2MR : (float)correnteSaida * this.correnteSaida110F1MR + this.correnteSaida110F2MR);
        if ((double)this.correnteSaida < 0.8) {
            this.correnteSaida = 0.0f;
        }
    }

    @Override
    public void setCargaElevada(boolean cargaElevada) {
        this.cargaElevada = this.potenciaReal > 1600.0f;
    }

    @Override
    public void setTemperaturaElevada(boolean temperaturaElevada) {
        if (this.temperaturaUPS > this.temperaturaCritica) {
            ++this.cntSobreTemperatura;
            if (this.cntSobreTemperatura > 5) {
                this.temperaturaElevada = true;
            }
        } else {
            this.cntSobreTemperatura = 0;
            this.temperaturaElevada = false;
        }
    }

    @Override
    public void setModoRede(boolean modoRede) {
        GregorianCalendar calendar = new GregorianCalendar();
        int mesAtual = calendar.get(2) + 1;
        int anoAtual = calendar.get(1);
        if (!this.modoRede) {
            this.modoRede = modoRede;
            if (this.modoRede) {
                Evento evt = new Evento(3, calendar.get(11), calendar.get(12), calendar.get(13), this.getDiaMes(), mesAtual, anoAtual);
                ProtocoloSolis solis = (ProtocoloSolis)this.protocoloUPS;
                solis.addEvento(evt);
            }
        }
        this.modoRede = modoRede;
    }

    @Override
    public void setEntradaLigada(boolean entradaLigada) {
        this.entradaLigada = this.tensaoEntrada > 0.0f;
    }

    @Override
    public boolean ligaEntrada() {
        this.protocoloUPS.ligaEntrada();
        return false;
    }

    @Override
    public boolean desligaEntrada() {
        this.protocoloUPS.desligaEntrada();
        return false;
    }

    @Override
    public boolean isAutoTesteBateriaAvaliable() {
        return true;
    }

    @Override
    public void setBateriaBaixa(boolean bateriaBaixa) {
        this.bateriaBaixa = this.tensaoBateria < 70.0f;
    }

    @Override
    public int calculaEstadoBaterias(float bateriaInicial, float bateriaFinal, float Potencia, int tempo) {
        GregorianCalendar calendar = new GregorianCalendar();
        int mesAtual = calendar.get(2) + 1;
        int anoAtual = calendar.get(1);
        Evento evt = new Evento(29, calendar.get(11), calendar.get(12), calendar.get(13), this.getDiaMes(), mesAtual, anoAtual);
        ProtocoloSolis solis = (ProtocoloSolis)this.protocoloUPS;
        solis.addEvento(evt);
        return 0;
    }
}

