/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.dispositivos;

import br.com.schneider.sgm.eventos.Evento;
import br.com.schneider.sgm.protocolo.ProtocoloPS;
import br.com.schneider.sgm.ups.AbstractUPS;
import java.util.GregorianCalendar;

public class PS800
extends AbstractUPS {
    protected ProtocoloPS protocoloUPS;
    protected int estadoReles;
    protected float TENSAO_ENTRADA_F1 = 1.64f;
    protected float TENSAO_ENTRADA_F2 = 3.34f;
    protected double TENSAO_BATERIA_F1 = 0.0711;
    protected double TENSAO_BATERIA_F2 = 0.2525;
    protected float TENSAO_MIN_BATERIA = 10.0f;
    protected float TENSAO_MAX_BATERIA = 14.5f;
    protected float TENSAO_FLUT_BATERIA = 13.54f;
    protected double CORRENTE_SAIDA_F1_MR = 0.09580012262415696;
    protected double CORRENTE_SAIDA_F2_MR = 0.44420753375977257;
    protected double CORRENTE_SAIDA_F1_MI = 0.0968054211035818;
    protected double CORRENTE_SAIDA_F2_MI = 0.4291845493562232;
    protected double[] POTENCIAUTIL_DETECCAO_CURVA1_F1 = new double[]{0.079, 0.089, 0.0972, 0.0, 0.0805, 0.0883, 0.0, 0.0981};
    protected double[] POTENCIAUTIL_DETECCAO_CURVA2_F1 = new double[]{0.0763, 0.081, 0.0919, 0.0, 0.0741, 0.0828, 0.0, 0.0938};
    protected double[] POTENCIAUTIL_DETECCAO_CURVA3_F1 = new double[]{0.0744, 0.0808, 0.0885, 0.0, 0.0732, 0.084, 0.0, 0.0955};
    protected double[] POTENCIAUTIL_DETECCAO_CURVA1_F2 = new double[]{49.107, 45.449, 48.092, 0.0, 43.633, 47.585, 0.0, 48.831};
    protected double[] POTENCIAUTIL_DETECCAO_CURVA2_F2 = new double[]{81.732, 94.459, 86.686, 0.0, 84.657, 84.999, 0.0, 78.097};
    protected double[] POTENCIAUTIL_DETECCAO_CURVA3_F2 = new double[]{122.06, 122.9, 125.75, 0.0, 120.39, 108.52, 0.0, 92.239};
    protected double[] POTENCIAUTIL_CURVA1_F1 = new double[]{0.08040007075206226, 0.0894, 0.0999, 0.0, 0.0813, 0.0905, 0.0, 0.1005};
    protected double[] POTENCIAUTIL_CURVA2_F1 = new double[]{0.08630063689870031, 0.0946, 0.1068, 0.0, 0.086, 0.0967, 0.0, 0.1088};
    protected double[] POTENCIAUTIL_CURVA3_F1 = new double[]{0.0896001146881468, 0.0991, 0.1116, 0.0, 0.0967, 0.1068, 0.0, 0.1169};
    protected double[] POTENCIAUTIL_CURVA1_F2 = new double[]{45.292, 41.928, 41.727, 0.0, 40.269, 41.81, 0.0, 43.458};
    protected double[] POTENCIAUTIL_CURVA2_F2 = new double[]{8.3927, 9.2393, 8.2852, 0.0, 8.301, 6.7636, 0.0, 8.2842};
    protected double[] POTENCIAUTIL_CURVA3_F2 = new double[]{-31.115, -33.777, -33.826, 0.0, -59.513, -57.729, 0.0, -41.333};
    protected double[] TENSAO_SAIDA_F1_MR = new double[]{0.7058159232072275, 0.8353521009105338, 0.8900756564307967, 0.0, 0.6681365671143182, 0.7438262421898244, 0.0, 0.8654262224145391};
    protected double[] TENSAO_SAIDA_F2_MR = new double[]{12.141, 5.2752, 10.43, 0.0, 17.565, 17.593, 0.0, 13.677};
    protected double[] TENSAO_SAIDA_F1_MI = new double[]{15.22, 16.51, 17.6, 0.0, 0.0, 0.0, 0.0, 0.0};
    protected double[] TENSAO_SAIDA_F2_MI = new double[]{10.82, 12.29, 13.7, 0.0, 0.0, 0.0, 0.0, 0.0};
    protected int[] autonomia100 = new int[]{26, 25, 24, 23, 22, 21, 20, 18, 17, 16, 14, 13, 11, 9, 7, 4, 2, 1};

    public PS800(ProtocoloPS protocol) {
        this.setProtocoloUPS(protocol);
        protocol.setModeloUPS(9);
    }

    public void setProtocoloUPS(ProtocoloPS protocolo) {
        this.protocoloUPS = protocolo;
    }

    @Override
    public boolean ativaBypass() {
        return false;
    }

    @Override
    public boolean configuraCalendario(int diaSemana, int diaMes, int mes, int ano) {
        return this.protocoloUPS.configuraCalendario(diaSemana, diaMes, mes, ano);
    }

    @Override
    public boolean configuraCalendarioRelogio(int diaSemana, int diaMes, int mes, int ano, int segundo, int minuto, int hora) {
        return this.protocoloUPS.configuraCalendarioRelogio(diaSemana, diaMes, mes, ano, segundo, minuto, hora);
    }

    @Override
    public boolean configuraRelogio(int segundos, int minutos, int horas) {
        return this.protocoloUPS.configuraRelogio(segundos, minutos, horas);
    }

    @Override
    public boolean desativaBypass() {
        return false;
    }

    @Override
    public boolean desligaEntrada() {
        return this.protocoloUPS.desligaEntrada();
    }

    @Override
    public boolean desligaSaida() {
        return this.protocoloUPS.desligaSaida();
    }

    @Override
    public void downloadEventos() {
        this.eventos = this.protocoloUPS.downloadEventos();
    }

    @Override
    public boolean finalizarAutoteste() {
        return false;
    }

    @Override
    public boolean iniciarAutoteste() {
        return false;
    }

    @Override
    public boolean ligaEntrada() {
        return this.protocoloUPS.ligaEntrada();
    }

    @Override
    public boolean ligaSaida() {
        return this.protocoloUPS.ligaSaida();
    }

    @Override
    public boolean programa(boolean[] dias, int horaLigar, int minutoLigar, int horaDesligar, int minutoDesligar, int diaSemana, int diaMes, int mes, int ano, int segundo, int minuto, int hora) {
        return this.protocoloUPS.configuraCalendarioRelogioSemana(diaSemana, diaMes, mes, ano, segundo, minuto, hora, dias, horaLigar, minutoLigar, horaDesligar, minutoDesligar);
    }

    @Override
    public boolean programaSemana(boolean[] dias, int horaLigar, int minutoLigar, int horaDesligar, int minutoDesligar) {
        return this.protocoloUPS.programaSemana(dias, horaLigar, minutoLigar, horaDesligar, minutoDesligar);
    }

    @Override
    public void setAno(int ano) {
        this.ano = ano;
    }

    @Override
    public void setAutonomiaBateria(int autonomiaBateria) {
        if (this.potenciaReal < 100.0f) {
            int i = autonomiaBateria - 151;
            if (i < 1) {
                i = 1;
            }
            if (i > this.autonomia100.length) {
                i = this.autonomia100.length;
            }
            this.autonomiaBateria = this.autonomia100[this.autonomia100.length - i];
        } else if (this.potenciaReal < 180.0f) {
            if (this.tensaoBateria >= 24.1f) {
                this.autonomiaBateria = 15;
            } else if (this.tensaoBateria >= 22.09f) {
                this.autonomiaBateria = 14;
            } else if (this.tensaoBateria >= 24.07f) {
                this.autonomiaBateria = 13;
            } else if (this.tensaoBateria >= 24.04f) {
                this.autonomiaBateria = 12;
            } else if (this.tensaoBateria >= 22.96f) {
                this.autonomiaBateria = 11;
            } else if (this.tensaoBateria >= 22.91f) {
                this.autonomiaBateria = 10;
            } else if (this.tensaoBateria >= 22.85f) {
                this.autonomiaBateria = 9;
            } else if (this.tensaoBateria >= 22.78f) {
                this.autonomiaBateria = 8;
            } else if (this.tensaoBateria >= 22.7f) {
                this.autonomiaBateria = 7;
            } else if (this.tensaoBateria >= 22.61f) {
                this.autonomiaBateria = 6;
            } else if (this.tensaoBateria >= 22.52f) {
                this.autonomiaBateria = 5;
            } else if (this.tensaoBateria >= 22.4f) {
                this.autonomiaBateria = 4;
            } else if (this.tensaoBateria >= 22.27f) {
                this.autonomiaBateria = 3;
            } else if (this.tensaoBateria >= 22.0f) {
                this.autonomiaBateria = 2;
            } else if (this.tensaoBateria >= 20.73f) {
                this.autonomiaBateria = 1;
            }
        } else if (this.potenciaReal < 200.0f) {
            if (this.tensaoBateria >= 22.94f) {
                this.autonomiaBateria = 10;
            } else if (this.tensaoBateria >= 22.9f) {
                this.autonomiaBateria = 7;
            } else if (this.tensaoBateria >= 22.79f) {
                this.autonomiaBateria = 6;
            } else if (this.tensaoBateria >= 22.69f) {
                this.autonomiaBateria = 5;
            } else if (this.tensaoBateria >= 22.52f) {
                this.autonomiaBateria = 4;
            } else if (this.tensaoBateria >= 22.39f) {
                this.autonomiaBateria = 3;
            } else if (this.tensaoBateria >= 22.17f) {
                this.autonomiaBateria = 2;
            } else if (this.tensaoBateria >= 20.87f) {
                this.autonomiaBateria = 1;
            }
        } else if (this.potenciaReal < 250.0f) {
            if (this.tensaoBateria >= 22.81f) {
                this.autonomiaBateria = 7;
            } else if (this.tensaoBateria >= 22.75f) {
                this.autonomiaBateria = 6;
            } else if (this.tensaoBateria >= 22.67f) {
                this.autonomiaBateria = 5;
            } else if (this.tensaoBateria >= 22.52f) {
                this.autonomiaBateria = 4;
            } else if (this.tensaoBateria >= 22.34f) {
                this.autonomiaBateria = 3;
            } else if (this.tensaoBateria >= 22.11f) {
                this.autonomiaBateria = 2;
            } else if (this.tensaoBateria >= 20.85f) {
                this.autonomiaBateria = 1;
            }
        } else {
            this.autonomiaBateria = this.potenciaReal < 300.0f ? (autonomiaBateria > 154 ? 3 : (autonomiaBateria > 149 ? 2 : 1)) : (autonomiaBateria > 143 ? 2 : 1);
        }
        if (this.expansorBateria != 0) {
            this.autonomiaBateria = (int)((double)this.autonomiaBateria * ((double)this.expansorBateria / 9.75));
        }
    }

    @Override
    public void setBateriaBaixa(boolean bateriaBaixa) {
        if (this.modoBateria) {
            this.bateriaBaixa = this.tensaoBateria < 11.0f;
        }
    }

    @Override
    public void setBateriaCarregada(boolean bateriaCarregada) {
        if (this.modoBateria) {
            this.bateriaCarregada = bateriaCarregada;
        }
    }

    @Override
    public void setBateriaCritica(boolean bateriaCritica) {
        this.bateriaCritica = this.tensaoBateria < 10.0f;
    }

    @Override
    public void setBateriaDescarregada(boolean bateriaDescarregada) {
        this.bateriaDescarregada = bateriaDescarregada;
    }

    @Override
    public void setBateriaTensaoNominal(int bateriaTensaoNominal) {
        this.bateriaTensaoNominal = 12.4f;
    }

    @Override
    public void setBypassAtivado(boolean bypassAtivado) {
    }

    @Override
    public void setCargaElevada(boolean cargaElevada) {
        this.cargaElevada = cargaElevada;
    }

    @Override
    public void setCarregandoBateria(boolean carregandoBateria) {
        this.carregandoBateria = carregandoBateria;
    }

    @Override
    public void setCorrenteEntrada(int correnteEntrada) {
        this.correnteEntrada = !this.modoRede ? 0.0f : 1.1f * (this.potenciaAparente / this.tensaoEntrada);
    }

    @Override
    public void setCorrenteSaida(int correnteSaida) {
        this.correnteSaida = this.modoRede ? (float)(this.CORRENTE_SAIDA_F1_MR * (double)correnteSaida + this.CORRENTE_SAIDA_F2_MR) : (this.saidaLigada ? (float)(this.CORRENTE_SAIDA_F1_MI * (double)correnteSaida + this.CORRENTE_SAIDA_F2_MI) : 0.0f);
    }

    @Override
    public void setDiaMes(int diaMes) {
        this.diaMes = diaMes;
    }

    @Override
    public void setDiaSemana(int diaSemana) {
        this.diaSemana = diaSemana;
    }

    @Override
    public void setDiasSemanaProgramados(boolean[] diasSemanaProgramados) {
        this.diasSemanaProgramados = diasSemanaProgramados;
    }

    @Override
    public void setEntradaLigada(boolean entradaLigada) {
        this.entradaLigada = this.tensaoEntrada > 0.0f;
    }

    @Override
    public void setExpansorBateria(int expansorBateria) {
        this.expansorBateria = expansorBateria;
    }

    public void setConfiguracaoReles(int conf) {
        this.estadoReles = (conf & 0x38) >> 3;
    }

    @Override
    public void setFatorPotenciaCarga(int fatorPotenciaCarga) {
        if (this.potenciaAparente <= 0.0f) {
            this.fatorPotenciaCarga = 0.0f;
        } else {
            try {
                this.fatorPotenciaCarga = (int)(this.potenciaReal / this.potenciaAparente * 100.0f);
                if (this.fatorPotenciaCarga > 100.0f) {
                    this.fatorPotenciaCarga = 100.0f;
                }
                this.fatorPotenciaCarga /= 100.0f;
            }
            catch (Exception e) {
                this.fatorPotenciaCarga = 100.0f;
                this.fatorPotenciaCarga /= 100.0f;
            }
        }
    }

    @Override
    public boolean isTemperaturaAvaliable() {
        return false;
    }

    @Override
    public void setFatorPotenciaEquipamento(int fatorPotenciaEquipamento) {
        this.fatorPotenciaEquipamento = 60;
    }

    @Override
    public void setFrequenciaEntrada(int frequenciaEntrada) {
        this.frequenciaEntrada = this.tensaoEntrada > 0.0f ? (float)(0.37 * (double)(257 - (frequenciaEntrada >> 8))) : 0.0f;
    }

    @Override
    public void setFrequenciaSaida(int frequenciaSaida) {
        this.frequenciaSaida = 0.0f;
        if (!this.saidaLigada) {
            this.frequenciaSaida = 0.0f;
        } else if (this.modoRede) {
            this.frequenciaSaida = this.frequenciaEntrada;
        } else if (this.modoBateria) {
            this.frequenciaSaida = 60.0f;
        }
    }

    @Override
    public void setHora(int hora) {
        this.hora = hora;
    }

    @Override
    public void setHoraDesligar(int horaDesligar) {
        this.horaDesligar = horaDesligar;
    }

    @Override
    public void setHoraLigar(int horaLigar) {
        this.horaLigar = horaLigar;
    }

    @Override
    public void setLimiteInferiorTensaoEntrada(int limiteInferiorTensaoEntrada) {
        this.limiteInferiorTensaoEntrada = this.tensaoEntrada220 ? 130.0f : 50.0f;
    }

    @Override
    public void setLimiteInferiorTensaoSaida(int limiteInferiorTensaoSaida) {
        this.limiteInferiorTensaoSaida = 96.0f;
    }

    @Override
    public void setLimiteSuperiorTensaoEntrada(int limiteSuperiorTensaoEntrada) {
        this.limiteSuperiorTensaoEntrada = this.tensaoEntrada220 ? 280.0f : 180.0f;
    }

    @Override
    public void setLimiteSuperiorTensaoSaida(int limiteSuperiorTensaoSaida) {
        this.limiteSuperiorTensaoSaida = 128.0f;
    }

    @Override
    public void setMes(int mes) {
        this.mes = mes;
    }

    @Override
    public void setMinutoDesligar(int minutoDesligar) {
        this.minutoDesligar = minutoDesligar;
    }

    @Override
    public void setMinutoLigar(int minutoLigar) {
        this.minutoLigar = minutoLigar;
    }

    @Override
    public void setMinutos(int minutos) {
        this.minutos = minutos;
    }

    @Override
    public void setModoBateria(boolean modoBateria) {
        this.modoBateria = modoBateria;
    }

    @Override
    public void setModoBypass(boolean modoBypass) {
        this.modoBypass = modoBypass;
    }

    @Override
    public void setModoRede(boolean modoRede) {
        this.modoRede = modoRede;
    }

    @Override
    public void setPercentualBateria(int percentualBateria) {
        this.percentualBateria = this.carregandoBateria ? (int)(100.0f * ((this.tensaoBateria - this.TENSAO_MIN_BATERIA) / (this.TENSAO_MAX_BATERIA - this.TENSAO_MIN_BATERIA))) : (int)(100.0f * ((this.tensaoBateria - this.TENSAO_MIN_BATERIA) / (this.TENSAO_FLUT_BATERIA - this.TENSAO_MIN_BATERIA)));
        if (this.percentualBateria > 100) {
            this.percentualBateria = 100;
        }
        if (this.percentualBateria < 0) {
            this.percentualBateria = 0;
        }
    }

    @Override
    public void setPotenciaAparente(int potenciaAparente) {
        this.potenciaAparente = this.correnteSaida * this.tensaoSaida;
    }

    @Override
    public void setPotenciaNominalVA(int potenciaNominalVA) {
        this.potenciaNominalVA = 800;
    }

    @Override
    public void setPotenciaNominalW(int potenciaNominalW) {
        this.potenciaNominalW = this.saidaLigada ? (int)(this.tensaoSaida * this.correnteSaida) : 0;
    }

    @Override
    public void setPotenciaReal(int potenciaReal) {
        double difNlin2;
        double pLin = this.POTENCIAUTIL_DETECCAO_CURVA1_F1[this.estadoReles] * (double)potenciaReal + this.POTENCIAUTIL_DETECCAO_CURVA1_F2[this.estadoReles];
        double pVa = this.POTENCIAUTIL_DETECCAO_CURVA2_F1[this.estadoReles] * (double)potenciaReal + this.POTENCIAUTIL_DETECCAO_CURVA2_F2[this.estadoReles];
        double pVa2 = this.POTENCIAUTIL_DETECCAO_CURVA3_F1[this.estadoReles] * (double)potenciaReal + this.POTENCIAUTIL_DETECCAO_CURVA3_F2[this.estadoReles];
        double difLin = pLin - (double)this.potenciaAparente;
        if (difLin < 0.0) {
            difLin *= -1.0;
        }
        double difNlin = pVa - (double)this.potenciaAparente;
        if (difLin < 0.0) {
            difLin *= -1.0;
        }
        if ((difNlin2 = pVa2 - (double)this.potenciaAparente) < 0.0) {
            difNlin2 *= -1.0;
        }
        this.potenciaReal = difLin < difNlin && difLin < difNlin2 ? (float)(this.POTENCIAUTIL_CURVA1_F1[this.estadoReles] * (double)potenciaReal + this.POTENCIAUTIL_CURVA1_F2[this.estadoReles]) : (difNlin < difNlin2 ? (float)(this.POTENCIAUTIL_CURVA2_F1[this.estadoReles] * (double)potenciaReal + this.POTENCIAUTIL_CURVA2_F2[this.estadoReles]) : (float)(this.POTENCIAUTIL_CURVA3_F1[this.estadoReles] * (double)potenciaReal + this.POTENCIAUTIL_CURVA3_F2[this.estadoReles]));
        if (!this.saidaLigada) {
            this.potenciaReal = 0.0f;
        }
        if (this.potenciaAparente < this.potenciaReal) {
            float f = this.potenciaAparente;
            this.potenciaAparente = this.potenciaReal;
            this.potenciaReal = f;
        }
    }

    @Override
    public void setSaidaLigada(boolean saidaLigada) {
        this.saidaLigada = saidaLigada;
    }

    @Override
    public void setSegundos(int segundos) {
        this.segundos = segundos;
    }

    @Override
    public void setSobrecarga(boolean sobrecarga) {
        if (this.potenciaReal > 435.0f) {
            this.sobrecarga = true;
            this.cargaElevada = true;
        } else {
            this.sobrecarga = false;
            this.cargaElevada = false;
        }
    }

    @Override
    public void setSuperAquecimento(boolean superAquecimento) {
        this.superAquecimento = superAquecimento;
    }

    @Override
    public void setTemperaturaCritica(int temperaturaCritica) {
        this.temperaturaCritica = temperaturaCritica;
    }

    @Override
    public void setTemperaturaElevada(boolean temperaturaElevada) {
        this.temperaturaElevada = temperaturaElevada;
    }

    @Override
    public void setTemperaturaUPS(int temperaturaUPS) {
        this.temperaturaUPS = temperaturaUPS;
    }

    @Override
    public void setTensaoBateria(int tensaoBateria) {
        this.tensaoBateria = (float)(this.TENSAO_BATERIA_F1 * (double)tensaoBateria + this.TENSAO_BATERIA_F2);
    }

    @Override
    public void setTensaoBoost(int tensaoBoost) {
        this.tensaoBoost = 0.0f;
    }

    @Override
    public void setTensaoEntrada220(boolean tensaoEntrada220) {
        this.tensaoEntrada220 = tensaoEntrada220;
    }

    @Override
    public void setTensaoEntradaNominal(int tensaoEntradaNominal) {
        if (this.modoRede) {
            this.tensaoEntradaNominal = this.tensaoEntrada220 ? 220.0f : 115.0f;
        }
    }

    @Override
    public void setTensaoSaida(int tensaoSaida) {
        if (!this.saidaLigada) {
            this.tensaoSaida = 0.0f;
        } else if (this.modoRede) {
            this.tensaoSaida = (float)(this.TENSAO_SAIDA_F1_MR[this.estadoReles] * (double)tensaoSaida + this.TENSAO_SAIDA_F2_MR[this.estadoReles]);
        } else {
            double a = tensaoSaida * 2;
            this.tensaoSaida = (float)((double)this.tensaoBateria * Math.sqrt(a /= 128.0) * this.TENSAO_SAIDA_F1_MI[this.estadoReles] - (double)this.correnteSaida * this.TENSAO_SAIDA_F2_MI[this.estadoReles]);
        }
    }

    @Override
    public void setTensaoSaida220(boolean tensaoSaida220) {
    }

    @Override
    public void setTensaoSaidaNominal(int tensaoSaidaNominal) {
        this.tensaoSaidaNominal = this.tensaoSaida220 ? 220.0f : 115.0f;
    }

    @Override
    public void setUsandoSomenteBateria(boolean usandoSomenteBateria) {
        this.usandoSomenteBateria = this.saidaLigada && !this.modoRede;
    }

    @Override
    public boolean shutdown() {
        return this.protocoloUPS.shutdown();
    }

    @Override
    public boolean shutdownReligamento() {
        return false;
    }

    @Override
    public void notifica() {
        this.setModoRede(this.protocoloUPS.getModoRede());
        this.setConfiguracaoReles(this.protocoloUPS.getConfiguracaoRele());
        this.setTensaoEntrada220(this.protocoloUPS.isTensaoEntrada220());
        this.setTensaoEntradaNominal(this.protocoloUPS.getTensaoEntradaNominal());
        this.setTensaoEntrada(this.protocoloUPS.getTensaoEntrada());
        this.setTensaoBateria(this.protocoloUPS.getTensaoBateria());
        this.setTensaoSaida220(this.protocoloUPS.isTensaoSaida220());
        this.setCorrenteSaida(this.protocoloUPS.getCorrenteSaida());
        this.setModoBateria(this.protocoloUPS.getModoBateria());
        this.setTensaoSaida(this.protocoloUPS.getTensaoSaida());
        this.setCorrenteEntrada(this.protocoloUPS.getCorrenteEntrada());
        this.setFrequenciaEntrada(this.protocoloUPS.getFrequenciaEntrada());
        this.setLimiteInferiorTensaoEntrada(this.protocoloUPS.getLimiteInferiorTensaoEntrada());
        this.setLimiteSuperiorTensaoEntrada(this.protocoloUPS.getLimiteSuperiorTensaoEntrada());
        this.setTensaoSaidaNominal(this.protocoloUPS.getTensaoSaidaNominal());
        this.setFrequenciaSaida(this.protocoloUPS.getFrequenciaSaida());
        this.setLimiteInferiorTensaoSaida(this.protocoloUPS.getLimiteInferiorTensaoSaida());
        this.setLimiteSuperiorTensaoSaida(this.protocoloUPS.getLimiteSuperiorTensaoSaida());
        this.setPotenciaAparente(this.protocoloUPS.getPotenciaAparente());
        this.setPotenciaReal(this.protocoloUPS.getPotenciaReal());
        this.setFatorPotenciaCarga(this.protocoloUPS.getFatorPotenciaCarga());
        this.setTensaoBoost(this.protocoloUPS.getTensaoBoost());
        this.setTemperaturaUPS(this.protocoloUPS.getTemperaturaUPS());
        this.setPercentualBateria(this.protocoloUPS.getPercentualBateria());
        this.setAutonomiaBateria(this.protocoloUPS.getTensaoBateria());
        this.setCarregandoBateria(this.protocoloUPS.isCarregandoBateria());
        this.setUsandoSomenteBateria(this.protocoloUPS.isUsandoSomenteBateria());
        this.setModoBypass(this.protocoloUPS.isModoBypass());
        this.setSuperAquecimento(this.protocoloUPS.isSuperAquecimento());
        this.setTemperaturaElevada(this.protocoloUPS.isTemperaturaElevada());
        this.setBateriaBaixa(this.protocoloUPS.isBateriaBaixa());
        this.setBateriaCritica(this.protocoloUPS.isBateriaCritica());
        this.setCargaElevada(this.protocoloUPS.isCargaElevada());
        this.setBateriaDescarregada(this.protocoloUPS.isBateriaDescarregada());
        this.setBateriaCarregada(this.protocoloUPS.isBateriaCarregada());
        this.setSobrecarga(this.protocoloUPS.isSobrecarga());
        this.setSegundos(this.protocoloUPS.getSegundos());
        this.setMinutos(this.protocoloUPS.getMinutos());
        this.setHora(this.protocoloUPS.getHora());
        this.setDiaSemana(this.protocoloUPS.getDiaSemana());
        this.setDiaMes(this.protocoloUPS.getDiaMes());
        this.setMes(this.protocoloUPS.getMes());
        this.setAno(this.protocoloUPS.getAno());
        this.setDiasSemanaProgramados(this.protocoloUPS.getDiasSemanaProgramados());
        this.setMinutoLigar(this.protocoloUPS.getMinutoLigar());
        this.setHoraLigar(this.protocoloUPS.getHoraLigar());
        this.setMinutoDesligar(this.protocoloUPS.getMinutoDesligar());
        this.setHoraDesligar(this.protocoloUPS.getHoraDesligar());
        this.setSaidaLigada(this.protocoloUPS.isSaidaLigada());
        this.setEntradaLigada(this.protocoloUPS.isEntradaLigada());
        this.setBypassAtivado(this.protocoloUPS.isBypassAtivado());
        this.downloadEventos();
        this.ouvinteUPS.notificaControle();
    }

    @Override
    public void setTensaoEntrada(int tensaoEntrada) {
        this.tensaoEntrada = (int)(this.TENSAO_ENTRADA_F1 * (float)tensaoEntrada + this.TENSAO_ENTRADA_F2);
    }

    @Override
    public boolean isAutoTesteBateriaAvaliable() {
        return true;
    }

    @Override
    public int calculaEstadoBaterias(float bateriaInicial, float bateriaFinal, float Potencia, int tempo) {
        GregorianCalendar calendar = new GregorianCalendar();
        int mesAtual = calendar.get(2) + 1;
        int anoAtual = calendar.get(1);
        Evento evt = new Evento(29, calendar.get(11), calendar.get(12), calendar.get(13), this.getDiaMes(), mesAtual, anoAtual);
        ProtocoloPS ps = this.protocoloUPS;
        ps.addEvento(evt);
        return 0;
    }
}

