/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.dispositivos;

import br.com.schneider.sgm.dispositivos.PS800;
import br.com.schneider.sgm.eventos.Evento;
import br.com.schneider.sgm.protocolo.ProtocoloPS;
import java.util.GregorianCalendar;

public class PS350_CII
extends PS800 {
    public PS350_CII(ProtocoloPS protocol) {
        super(protocol);
        this.instanciasGlobais();
        protocol.setModeloUPS(8);
    }

    public void instanciasGlobais() {
        this.TENSAO_ENTRADA_F1 = 1.7875f;
        this.TENSAO_ENTRADA_F2 = 24.582f;
        this.TENSAO_BATERIA_F1 = 0.0711;
        this.TENSAO_BATERIA_F2 = 0.2525;
        this.TENSAO_MIN_BATERIA = 10.0f;
        this.TENSAO_MAX_BATERIA = 14.5f;
        this.TENSAO_FLUT_BATERIA = 13.5f;
        this.CORRENTE_SAIDA_F1_MR = 0.0487;
        this.CORRENTE_SAIDA_F2_MR = 0.1927;
        this.CORRENTE_SAIDA_F1_MI = 0.0476;
        this.CORRENTE_SAIDA_F2_MI = 0.2016;
        this.POTENCIAUTIL_DETECCAO_CURVA1_F1 = new double[]{0.0469, 0.0518, 0.0577, 0.0, 0.0462, 0.0519, 0.0, 0.0571};
        this.POTENCIAUTIL_DETECCAO_CURVA2_F1 = new double[]{0.575, 0.0612, 0.0617, 0.0, 0.0551, 0.0591, 0.0, 0.0703};
        this.POTENCIAUTIL_DETECCAO_CURVA3_F1 = new double[]{0.0514, 0.0573, 0.0673, 0.0, 0.0534, 0.0531, 0.0, 0.0621};
        this.POTENCIAUTIL_DETECCAO_CURVA1_F2 = new double[]{29.599, 28.41, 26.039, 0.0, 30.108, 27.038, 0.0, 26.522};
        this.POTENCIAUTIL_DETECCAO_CURVA2_F2 = new double[]{34.364, 35.928, 48.289, 0.0, 32.934, 34.054, 0.0, 18.75};
        this.POTENCIAUTIL_DETECCAO_CURVA3_F2 = new double[]{61.184, 52.561, 29.872, 0.0, 43.087, 60.912, 0.0, 43.997};
        this.POTENCIAUTIL_CURVA1_F1 = new double[]{0.0469, 0.0518, 0.0577, 0.0, 0.0462, 0.0519, 0.0, 0.0571};
        this.POTENCIAUTIL_CURVA2_F1 = new double[]{0.0451, 0.0505, 0.0545, 0.0, 0.0462, 0.0491, 0.0, 0.0298};
        this.POTENCIAUTIL_CURVA3_F1 = new double[]{0.0421, 0.0474, 0.0593, 0.0, 0.0438, 0.0449, 0.0, 0.0522};
        this.POTENCIAUTIL_CURVA1_F2 = new double[]{29.599, 28.41, 26.039, 0.0, 30.108, 27.038, 0.0, 26.522};
        this.POTENCIAUTIL_CURVA2_F2 = new double[]{13.973, 8.9685, 16.709, 0.0, 12.001, 15.302, 0.0, 57.213};
        this.POTENCIAUTIL_CURVA3_F2 = new double[]{23.796, 15.544, -4.6501, 0.0, 19.27, 31.405, 0.0, 21.36};
        this.TENSAO_SAIDA_F1_MR = new double[]{0.9286, 1.0186, 1.0414, 0.0, 0.8995, 0.9641, 0.0, 0.9507};
        this.TENSAO_SAIDA_F2_MR = new double[]{9.9429, 9.2431, 16.933, 0.0, 13.11, 14.936, 0.0, 26.122};
        this.TENSAO_SAIDA_F1_MI = new double[]{13.9, 14.7, 15.47, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.TENSAO_SAIDA_F2_MI = new double[]{11.8, 10.52, 11.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    }

    @Override
    public void setSobrecarga(boolean sobrecarga) {
        if (this.potenciaReal > 655.0f) {
            this.sobrecarga = true;
            this.cargaElevada = true;
        } else {
            this.sobrecarga = false;
            this.cargaElevada = false;
        }
    }

    @Override
    public void setLimiteSuperiorTensaoSaida(int limiteSuperiorTensaoSaida) {
        this.limiteSuperiorTensaoSaida = 134.0f;
    }

    @Override
    public void setPotenciaReal(int potenciaReal) {
        double difNlin2;
        double pLin = this.POTENCIAUTIL_DETECCAO_CURVA1_F1[this.estadoReles] * (double)potenciaReal + this.POTENCIAUTIL_DETECCAO_CURVA1_F2[this.estadoReles];
        double pVa = this.POTENCIAUTIL_DETECCAO_CURVA2_F1[this.estadoReles] * (double)potenciaReal + this.POTENCIAUTIL_DETECCAO_CURVA2_F2[this.estadoReles];
        double pVa2 = this.POTENCIAUTIL_DETECCAO_CURVA3_F1[this.estadoReles] * (double)potenciaReal + this.POTENCIAUTIL_DETECCAO_CURVA3_F2[this.estadoReles];
        double difLin = pLin - (double)this.potenciaAparente;
        if (difLin < 0.0) {
            difLin *= -1.0;
        }
        double difNlin = pVa - (double)this.potenciaAparente;
        if (difLin < 0.0) {
            difLin *= -1.0;
        }
        if ((difNlin2 = pVa2 - (double)this.potenciaAparente) < 0.0) {
            difNlin2 *= -1.0;
        }
        this.potenciaReal = difLin < difNlin && difLin < difNlin2 ? (float)(this.POTENCIAUTIL_CURVA1_F1[this.estadoReles] * (double)potenciaReal + this.POTENCIAUTIL_CURVA1_F2[this.estadoReles]) : (difNlin < difNlin2 ? (float)(this.POTENCIAUTIL_CURVA2_F1[this.estadoReles] * (double)potenciaReal + this.POTENCIAUTIL_CURVA2_F2[this.estadoReles]) : (float)(this.POTENCIAUTIL_CURVA3_F1[this.estadoReles] * (double)potenciaReal + this.POTENCIAUTIL_CURVA3_F2[this.estadoReles]));
        if (!this.saidaLigada) {
            this.potenciaReal = 0.0f;
        }
        if (this.potenciaAparente < this.potenciaReal) {
            float f = this.potenciaAparente;
            this.potenciaAparente = this.potenciaReal;
            this.potenciaReal = f;
        }
        if (potenciaReal == 0) {
            this.potenciaReal = 0.0f;
        }
        if (this.correnteSaida == 0.0f) {
            this.potenciaReal = 0.0f;
            this.potenciaAparente = 0.0f;
        }
    }

    @Override
    public void setAutonomiaBateria(int autonomiaBateria) {
        if (this.potenciaReal < 120.0f) {
            this.autonomiaBateria = Math.round((float)(2.0782 * Math.pow(autonomiaBateria, 2.0) - 603.65 * (double)autonomiaBateria + 43789.0));
            this.autonomiaBateria /= 60;
            if (this.autonomiaBateria > 17) {
                this.autonomiaBateria = 17;
            }
        } else if (this.potenciaReal < 210.0f) {
            this.autonomiaBateria = Math.round((float)(0.455 * Math.pow(autonomiaBateria, 2.0) - 115.45 * (double)autonomiaBateria + 7297.3));
            this.autonomiaBateria /= 60;
            if (this.autonomiaBateria > 10) {
                this.autonomiaBateria = 10;
            }
        } else if (this.potenciaReal < 290.0f) {
            this.autonomiaBateria = Math.round((float)(-0.3321 * Math.pow(autonomiaBateria, 2.0) + 107.92 * (double)autonomiaBateria - 8483.7));
            this.autonomiaBateria /= 60;
            if (this.autonomiaBateria > 5) {
                this.autonomiaBateria = 5;
            }
        } else if (this.potenciaReal < 330.0f) {
            this.autonomiaBateria = Math.round((float)(-0.1636 * Math.pow(autonomiaBateria, 2.0) + 56.215 * (double)autonomiaBateria - 4564.3));
            this.autonomiaBateria /= 60;
            if (this.autonomiaBateria > 3) {
                this.autonomiaBateria = 3;
            }
        }
        if (this.expansorBateria != 0) {
            this.autonomiaBateria = (int)((double)this.autonomiaBateria * ((double)this.expansorBateria / 9.75));
        }
    }

    @Override
    public void setTensaoEntrada(int tensaoEntrada) {
        this.tensaoEntrada = (int)(this.TENSAO_ENTRADA_F1 * (float)tensaoEntrada + this.TENSAO_ENTRADA_F2);
        if (tensaoEntrada == 0) {
            this.tensaoEntrada = 0.0f;
        }
    }

    @Override
    public boolean isAutoTesteBateriaAvaliable() {
        return true;
    }

    @Override
    public int calculaEstadoBaterias(float bateriaInicial, float bateriaFinal, float Potencia, int tempo) {
        GregorianCalendar calendar = new GregorianCalendar();
        int mesAtual = calendar.get(2) + 1;
        int anoAtual = calendar.get(1);
        Evento evt = new Evento(29, calendar.get(11), calendar.get(12), calendar.get(13), this.getDiaMes(), mesAtual, anoAtual);
        this.protocoloUPS.addEvento(evt);
        return 0;
    }

    @Override
    public void setBateriaBaixa(boolean bateriaBaixa) {
        if (this.modoBateria) {
            this.bateriaBaixa = this.tensaoBateria < 11.0f;
        }
    }

    @Override
    public void setTensaoSaida(int tensaoSaida) {
        if (!this.saidaLigada) {
            this.tensaoSaida = 0.0f;
        } else if (this.modoRede) {
            this.tensaoSaida = (float)(this.TENSAO_SAIDA_F1_MR[this.estadoReles] * (double)tensaoSaida + this.TENSAO_SAIDA_F2_MR[this.estadoReles]);
            if (this.correnteSaida > 2.0f) {
                this.tensaoSaida -= 5.0f;
            }
        } else {
            double a = tensaoSaida * 2;
            this.tensaoSaida = (float)((double)this.tensaoBateria * Math.sqrt(a /= 128.0) * this.TENSAO_SAIDA_F1_MI[this.estadoReles] - (double)this.correnteSaida * this.TENSAO_SAIDA_F2_MI[this.estadoReles]);
        }
        if (tensaoSaida == 0) {
            this.tensaoSaida = 0.0f;
        }
    }

    @Override
    public void setCorrenteSaida(int correnteSaida) {
        this.correnteSaida = this.modoRede ? (float)(this.CORRENTE_SAIDA_F1_MR * (double)correnteSaida + this.CORRENTE_SAIDA_F2_MR) : (this.saidaLigada ? (float)(this.CORRENTE_SAIDA_F1_MI * (double)correnteSaida + this.CORRENTE_SAIDA_F2_MI) : 0.0f);
        if (correnteSaida == 0) {
            this.correnteSaida = 0.0f;
        }
    }

    @Override
    public void setBateriaCarregada(boolean bateriaCarregada) {
        if (this.modoBateria) {
            this.bateriaCarregada = bateriaCarregada;
        }
    }

    @Override
    public void setBateriaCritica(boolean bateriaCritica) {
        this.bateriaCritica = this.tensaoBateria < 10.0f;
    }
}

