/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.dispositivos;

import br.com.schneider.sgm.dispositivos.PS800;
import br.com.schneider.sgm.eventos.Evento;
import br.com.schneider.sgm.protocolo.ProtocoloPS;
import java.util.GregorianCalendar;

public class PS2200_22
extends PS800 {
    double media;
    int contadort = 0;
    protected float TENSAO_ENTRADA_F1_115;
    protected float TENSAO_ENTRADA_F2_115;

    @Override
    public float getTensaoSaidaNominal() {
        return 220.0f;
    }

    @Override
    public void setLimiteSuperiorTensaoSaida(int limiteSuperiorTensaoSaida) {
        this.limiteSuperiorTensaoSaida = 270.0f;
    }

    @Override
    public void setLimiteInferiorTensaoSaida(int limiteInferiorTensaoSaida) {
        this.limiteInferiorTensaoSaida = 170.0f;
    }

    @Override
    public void setLimiteSuperiorTensaoEntrada(int limiteSuperiorTensaoEntrada) {
        this.limiteSuperiorTensaoEntrada = 270.0f;
    }

    @Override
    public void setLimiteInferiorTensaoEntrada(int limiteInferiorTensaoEntrada) {
        this.limiteInferiorTensaoEntrada = 170.0f;
    }

    public PS2200_22(ProtocoloPS protocol) {
        super(protocol);
        this.instanciasGlobais();
        protocol.setModeloUPS(10);
    }

    public void instanciasGlobais() {
        this.TENSAO_ENTRADA_F1 = 1.5068f;
        this.TENSAO_ENTRADA_F2 = 11.37f;
        this.TENSAO_ENTRADA_F1_115 = 1.58f;
        this.TENSAO_ENTRADA_F2_115 = 2.86f;
        this.TENSAO_BATERIA_F1 = 0.16;
        this.TENSAO_BATERIA_F2 = -0.76;
        this.TENSAO_MIN_BATERIA = 20.0f;
        this.TENSAO_MAX_BATERIA = 29.5f;
        this.TENSAO_FLUT_BATERIA = 27.0f;
        this.CORRENTE_SAIDA_F1_MR = 0.0634f;
        this.CORRENTE_SAIDA_F2_MR = 0.4099f;
        this.CORRENTE_SAIDA_F1_MI = 0.0656f;
        this.CORRENTE_SAIDA_F2_MI = 0.3853f;
        this.POTENCIAUTIL_DETECCAO_CURVA1_F1 = new double[]{0.2262, 0.2262, 0.2536, 0.24, 0.24, 0.2303, 0.2535, 0.28};
        this.POTENCIAUTIL_DETECCAO_CURVA2_F1 = new double[]{0.0763, 0.081, 0.0919, 0.0, 0.0741, 0.0828, 0.0, 0.0938};
        this.POTENCIAUTIL_DETECCAO_CURVA3_F1 = new double[]{0.0744, 0.0808, 0.0885, 0.0, 0.0732, 0.084, 0.0, 0.0955};
        this.POTENCIAUTIL_DETECCAO_CURVA1_F2 = new double[]{21.075, 21.075, 46.886, 20.281, 36.958, 43.75, 36.291, 85.67};
        this.POTENCIAUTIL_DETECCAO_CURVA2_F2 = new double[]{81.732, 94.459, 86.686, 0.0, 84.657, 84.999, 0.0, 78.097};
        this.POTENCIAUTIL_DETECCAO_CURVA3_F2 = new double[]{122.06, 122.9, 125.75, 0.0, 120.39, 108.52, 0.0, 92.239};
        this.POTENCIAUTIL_CURVA1_F1 = new double[]{0.08040007075206226, 0.0894, 0.0999, 0.0, 0.0813, 0.0905, 0.0, 0.1005};
        this.POTENCIAUTIL_CURVA2_F1 = new double[]{0.08630063689870031, 0.0946, 0.1068, 0.0, 0.086, 0.0967, 0.0, 0.1088};
        this.POTENCIAUTIL_CURVA3_F1 = new double[]{0.0896001146881468, 0.0991, 0.1116, 0.0, 0.0967, 0.1068, 0.0, 0.1169};
        this.POTENCIAUTIL_CURVA1_F2 = new double[]{45.292, 41.928, 41.727, 0.0, 40.269, 41.81, 0.0, 43.458};
        this.POTENCIAUTIL_CURVA2_F2 = new double[]{8.3927, 9.2393, 8.2852, 0.0, 8.301, 6.7636, 0.0, 8.2842};
        this.POTENCIAUTIL_CURVA3_F2 = new double[]{-31.115, -33.777, -33.826, 0.0, -59.513, -57.729, 0.0, -41.333};
        this.TENSAO_SAIDA_F1_MR = new double[]{2.5085, 2.8814, 3.0, 0.0, 0.0, 3.4571, 3.2, 0.0};
        this.TENSAO_SAIDA_F2_MR = new double[]{30.508, 22.288, 30.5, 0.0, 0.0, -15.057, 18.2, 0.0};
        this.TENSAO_SAIDA_F1_MI = new double[]{2.5, 2.5, 2.5, 2.5, 2.5, 2.5, 2.5, 2.5};
        this.TENSAO_SAIDA_F2_MI = new double[]{39.5, 39.5, 39.5, 39.5, 39.5, 39.5, 39.5, 39.5};
        this.autonomia100 = new int[]{26, 25, 24, 23, 22, 21, 20, 18, 17, 16, 14, 13, 11, 9, 7, 4, 2, 1};
    }

    @Override
    public void setSobrecarga(boolean sobrecarga) {
        if (this.potenciaReal > 1200.0f) {
            this.sobrecarga = true;
            this.cargaElevada = true;
        } else {
            this.sobrecarga = false;
            this.cargaElevada = false;
        }
    }

    @Override
    public void setPotenciaReal(int potenciaReal) {
        double potRe = this.modoRede ? this.POTENCIAUTIL_DETECCAO_CURVA1_F1[this.estadoReles] * (double)potenciaReal + this.POTENCIAUTIL_DETECCAO_CURVA1_F2[this.estadoReles] : 0.1994 * (double)potenciaReal + 78.199;
        if (!this.saidaLigada || this.potenciaAparente == 0.0f) {
            potRe = 0.0;
        }
        this.potenciaReal = (float)potRe;
        if (this.potenciaReal > this.potenciaAparente) {
            this.potenciaAparente = this.potenciaReal;
        }
    }

    @Override
    public void setAutonomiaBateria(int tensaoBateria) {
        float autonomiaBateria = (float)(this.TENSAO_BATERIA_F1 * (double)tensaoBateria + this.TENSAO_BATERIA_F2);
        if (!this.saidaLigada) {
            this.autonomiaBateria = 0;
            return;
        }
        if (this.potenciaReal < 103.0f) {
            this.autonomiaBateria = Math.round((float)(4.0561 * Math.pow(autonomiaBateria, 2.0) - 175.36 * (double)autonomiaBateria + 1899.4));
            if (this.autonomiaBateria > 68) {
                this.autonomiaBateria = 68;
            }
        } else if (this.potenciaReal < 242.0f) {
            this.autonomiaBateria = Math.round((float)(1.4616 * Math.pow(autonomiaBateria, 2.0) - 60.009 * (double)autonomiaBateria + 617.29));
            if (this.autonomiaBateria > 32) {
                this.autonomiaBateria = 32;
            }
        } else if (this.potenciaReal < 350.0f) {
            this.autonomiaBateria = Math.round((float)(-0.4561 * Math.pow(autonomiaBateria, 2.0) + 25.521 * (double)autonomiaBateria - 336.49));
            if (this.autonomiaBateria > 16) {
                this.autonomiaBateria = 16;
            }
        } else if (this.potenciaReal < 470.0f) {
            this.autonomiaBateria = Math.round((float)(0.4426 * Math.pow(autonomiaBateria, 2.0) - 16.549 * (double)autonomiaBateria + 152.03));
            if (this.autonomiaBateria > 14) {
                this.autonomiaBateria = 14;
            }
        } else if (this.potenciaReal < 617.0f) {
            this.autonomiaBateria = Math.round((float)(0.2526 * Math.pow(autonomiaBateria, 2.0) - 8.4266 * (double)autonomiaBateria + 66.345));
            if (this.autonomiaBateria > 12) {
                this.autonomiaBateria = 12;
            }
        } else if (this.potenciaReal < 810.0f) {
            this.autonomiaBateria = Math.round((float)(0.187 * Math.pow(this.tensaoBateria, 2.0) - 6.4851 * (double)this.tensaoBateria + 54.985));
            if (this.autonomiaBateria > 9) {
                this.autonomiaBateria = 9;
            }
        } else if (this.potenciaReal < 1006.0f) {
            this.autonomiaBateria = Math.round((float)(-0.0116 * Math.pow(autonomiaBateria, 2.0) + 0.9699 * (double)autonomiaBateria - 14.325));
            if (this.autonomiaBateria > 4) {
                this.autonomiaBateria = 4;
            }
        } else if (this.potenciaReal < 1270.0f) {
            this.autonomiaBateria = Math.round((float)(-0.048 * Math.pow(autonomiaBateria, 2.0) + 3.0226 * (double)autonomiaBateria - 40.889));
            if (this.autonomiaBateria > 4) {
                this.autonomiaBateria = 4;
            }
        }
        if (this.expansorBateria != 0) {
            this.autonomiaBateria = (int)((double)this.autonomiaBateria * (1.0 + (double)this.expansorBateria / 14.0));
        }
        if (this.autonomiaBateria <= 0) {
            this.autonomiaBateria = 1;
        }
    }

    @Override
    public void setTensaoSaida(int tensaoSaida) {
        this.tensaoSaida = this.modoRede ? (float)(this.TENSAO_SAIDA_F1_MR[this.estadoReles] * (double)tensaoSaida + this.TENSAO_SAIDA_F2_MR[this.estadoReles]) : (float)(this.TENSAO_SAIDA_F1_MI[this.estadoReles] * (double)tensaoSaida + this.TENSAO_SAIDA_F2_MI[this.estadoReles]);
        if (!this.saidaLigada) {
            this.tensaoSaida = 0.0f;
        }
    }

    @Override
    public void setTensaoBateria(int tensaoBateria) {
        this.tensaoBateria = (float)(this.TENSAO_BATERIA_F1 * (double)tensaoBateria + this.TENSAO_BATERIA_F2);
    }

    @Override
    public void setTensaoEntrada(int tensaoEntrada) {
        this.tensaoEntrada = (int)(this.TENSAO_ENTRADA_F1 * (float)tensaoEntrada + this.TENSAO_ENTRADA_F2);
        if (this.tensaoEntrada < 50.0f) {
            this.tensaoEntrada = 0.0f;
        }
    }

    @Override
    public void setCorrenteSaida(int correnteSaida) {
        this.correnteSaida = this.modoRede ? (float)(this.CORRENTE_SAIDA_F1_MR * (double)correnteSaida + this.CORRENTE_SAIDA_F2_MR) : (this.saidaLigada ? (float)(this.CORRENTE_SAIDA_F1_MI * (double)correnteSaida + this.CORRENTE_SAIDA_F2_MI) : 0.0f);
        if (correnteSaida == 0) {
            this.correnteSaida = 0.0f;
        }
    }

    @Override
    public boolean isAutoTesteBateriaAvaliable() {
        return true;
    }

    @Override
    public int calculaEstadoBaterias(float bateriaInicial, float bateriaFinal, float Potencia, int tempo) {
        GregorianCalendar calendar = new GregorianCalendar();
        int mesAtual = calendar.get(2) + 1;
        int anoAtual = calendar.get(1);
        Evento evt = new Evento(29, calendar.get(11), calendar.get(12), calendar.get(13), this.getDiaMes(), mesAtual, anoAtual);
        this.protocoloUPS.addEvento(evt);
        return 0;
    }

    @Override
    public void setBateriaBaixa(boolean bateriaBaixa) {
        this.bateriaBaixa = this.tensaoBateria < 19.0f;
    }
}

