/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.dispositivos;

import br.com.schneider.sgm.dispositivos.PS800;
import br.com.schneider.sgm.eventos.Evento;
import br.com.schneider.sgm.protocolo.ProtocoloPS;
import java.util.GregorianCalendar;

public class BZ1500
extends PS800 {
    public BZ1500(ProtocoloPS protocol) {
        super(protocol);
        this.instanciasGlobais();
        protocol.setModeloUPS(10);
    }

    public void instanciasGlobais() {
        this.TENSAO_ENTRADA_F1 = 1.8f;
        this.TENSAO_ENTRADA_F2 = 2.224f;
        this.TENSAO_BATERIA_F1 = 0.1513;
        this.TENSAO_BATERIA_F2 = 0.7153;
        this.TENSAO_MIN_BATERIA = 20.0f;
        this.TENSAO_MAX_BATERIA = 29.5f;
        this.TENSAO_FLUT_BATERIA = 27.0f;
        this.CORRENTE_SAIDA_F1_MR = 0.1264;
        this.CORRENTE_SAIDA_F2_MR = 0.522;
        this.CORRENTE_SAIDA_F1_MI = 0.1303;
        this.CORRENTE_SAIDA_F2_MI = 0.468;
        this.TENSAO_SAIDA_F1_MR = new double[]{0.9266, 0.9266, 0.9266, 0.9266, 0.9266, 0.9266, 0.9266, 0.9266};
        this.TENSAO_SAIDA_F2_MR = new double[]{5.0694, 5.0694, 5.0694, 5.0694, 5.0694, 5.0694, 5.0694, 5.0694};
        this.TENSAO_SAIDA_F2_MI = new double[]{5.59, 9.47, 13.7, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.TENSAO_SAIDA_F1_MI = new double[]{5.4, 6.5, 17.6, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.autonomia100 = new int[]{26, 25, 24, 23, 22, 21, 20, 18, 17, 16, 14, 13, 11, 9, 7, 4, 2, 1};
    }

    @Override
    public void setSobrecarga(boolean sobrecarga) {
        if (this.potenciaReal > 820.0f) {
            this.sobrecarga = true;
            this.cargaElevada = true;
        } else {
            this.sobrecarga = false;
            this.cargaElevada = false;
        }
    }

    @Override
    public void setPotenciaReal(int potenciaReal) {
        this.potenciaReal = (int)(0.1127 * (double)potenciaReal + 50.031);
        if ((double)this.correnteSaida < 0.7) {
            this.potenciaReal = this.potenciaAparente;
        }
        if (this.potenciaAparente < this.potenciaReal) {
            float f = this.potenciaAparente;
            this.potenciaAparente = this.potenciaReal;
            this.potenciaReal = f;
        }
    }

    @Override
    public void setAutonomiaBateria(int autonomiaBateria) {
        if (this.potenciaReal < 120.0f) {
            this.autonomiaBateria = Math.round((float)(0.0982 * Math.pow(autonomiaBateria, 2.0) - 27.131 * (double)autonomiaBateria + 1875.18));
            if (this.autonomiaBateria > 60) {
                this.autonomiaBateria = 60;
            }
        } else if (this.potenciaReal < 230.0f) {
            this.autonomiaBateria = Math.round((float)(0.0663 * Math.pow(autonomiaBateria, 2.0) - 18.252 * (double)autonomiaBateria + 1257.2));
            if (this.autonomiaBateria > 30) {
                this.autonomiaBateria = 30;
            }
        } else if (this.potenciaReal < 330.0f) {
            this.autonomiaBateria = Math.round((float)(0.0225 * Math.pow(autonomiaBateria, 2.0) - 5.9113 * (double)autonomiaBateria + 389.08));
            if (this.autonomiaBateria > 13) {
                this.autonomiaBateria = 13;
            }
        } else if (this.potenciaReal < 430.0f) {
            this.autonomiaBateria = Math.round((float)(9.0E-4 * Math.pow(autonomiaBateria, 2.0) + 3.3172 * (double)autonomiaBateria - 272.34));
            if (this.autonomiaBateria > 10) {
                this.autonomiaBateria = 10;
            }
        } else if (this.potenciaReal < 530.0f) {
            this.autonomiaBateria = Math.round((float)(0.5711 * Math.pow(this.tensaoBateria, 2.0) - 23.484 * (double)this.tensaoBateria + 241.81));
            if (this.autonomiaBateria > 8) {
                this.autonomiaBateria = 8;
            }
        } else if (this.potenciaReal < 630.0f) {
            this.autonomiaBateria = Math.round((float)(0.0091 * Math.pow(autonomiaBateria, 2.0) - 2.3133 * (double)autonomiaBateria + 147.62));
            if (this.autonomiaBateria > 8) {
                this.autonomiaBateria = 8;
            }
        } else if (this.potenciaReal < 730.0f) {
            this.autonomiaBateria = Math.round((float)(9.0E-4 * Math.pow(autonomiaBateria, 2.0) - 1.422 * (double)autonomiaBateria + 136.22));
            if (this.autonomiaBateria > 6) {
                this.autonomiaBateria = 6;
            }
        }
        if (this.expansorBateria != 0) {
            this.autonomiaBateria = (int)((double)this.autonomiaBateria * ((double)this.expansorBateria / 9.75));
        }
    }

    @Override
    public void setTensaoBateria(int tensaoBateria) {
        this.tensaoBateria = (float)(this.TENSAO_BATERIA_F1 * (double)tensaoBateria + this.TENSAO_BATERIA_F2);
    }

    @Override
    public void setTensaoEntrada(int tensaoEntrada) {
        this.tensaoEntrada = (int)(-1.0E-4f * (float)tensaoEntrada * (float)tensaoEntrada + 1.8234f * (float)tensaoEntrada + 1.2181f);
    }

    @Override
    public void setCorrenteSaida(int correnteSaida) {
        this.correnteSaida = this.modoRede ? (float)(this.CORRENTE_SAIDA_F1_MR * (double)correnteSaida + this.CORRENTE_SAIDA_F2_MR) : (this.saidaLigada ? (float)(this.CORRENTE_SAIDA_F1_MI * (double)correnteSaida + this.CORRENTE_SAIDA_F2_MI) : 0.0f);
        if (correnteSaida == 0) {
            this.correnteSaida = 0.0f;
        }
    }

    @Override
    public boolean isAutoTesteBateriaAvaliable() {
        return true;
    }

    @Override
    public int calculaEstadoBaterias(float bateriaInicial, float bateriaFinal, float Potencia, int tempo) {
        GregorianCalendar calendar = new GregorianCalendar();
        int mesAtual = calendar.get(2) + 1;
        int anoAtual = calendar.get(1);
        Evento evt = new Evento(29, calendar.get(11), calendar.get(12), calendar.get(13), this.getDiaMes(), mesAtual, anoAtual);
        this.protocoloUPS.addEvento(evt);
        return 0;
    }

    @Override
    public void setBateriaBaixa(boolean bateriaBaixa) {
        if (this.modoBateria) {
            this.bateriaBaixa = this.tensaoBateria < 19.0f;
        }
    }

    @Override
    public void setTensaoSaida(int tensaoSaida) {
        if (!this.saidaLigada) {
            this.tensaoSaida = 0.0f;
        } else if (this.modoRede) {
            this.tensaoSaida = (float)(this.TENSAO_SAIDA_F1_MR[this.estadoReles] * (double)tensaoSaida - this.TENSAO_SAIDA_F2_MR[this.estadoReles]);
        } else {
            double a = tensaoSaida * 2;
            this.tensaoSaida = (float)((double)this.tensaoBateria * Math.sqrt(a /= 128.0) * this.TENSAO_SAIDA_F1_MI[this.estadoReles] - (double)this.correnteSaida * this.TENSAO_SAIDA_F2_MI[this.estadoReles]);
            System.out.println(this.TENSAO_SAIDA_F1_MI[this.estadoReles]);
        }
    }

    @Override
    public void setConfiguracaoReles(int conf) {
        this.estadoReles = (conf & 0x28) >> 3;
    }
}

