/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.controle;

import br.com.schneider.sgm.comunicacao.Communication;
import br.com.schneider.sgm.config.BuscaParametrosXML;
import br.com.schneider.sgm.config.PathConfig;
import br.com.schneider.sgm.dispositivos.BZ1500;
import br.com.schneider.sgm.dispositivos.PS2200;
import br.com.schneider.sgm.dispositivos.PS2200_22;
import br.com.schneider.sgm.dispositivos.PS350_CII;
import br.com.schneider.sgm.dispositivos.PS800;
import br.com.schneider.sgm.dispositivos.Rhino;
import br.com.schneider.sgm.dispositivos.SolisDCM15;
import br.com.schneider.sgm.dispositivos.SolisLI700;
import br.com.schneider.sgm.dispositivos.SolisM11;
import br.com.schneider.sgm.dispositivos.SolisM13;
import br.com.schneider.sgm.dispositivos.SolisM14;
import br.com.schneider.sgm.dispositivos.SolisM15;
import br.com.schneider.sgm.dispositivos.Stay1200_USB;
import br.com.schneider.sgm.dispositivos.Stay700_USB;
import br.com.schneider.sgm.eventos.BatTesteListener;
import br.com.schneider.sgm.eventos.ControleListener;
import br.com.schneider.sgm.eventos.Evento;
import br.com.schneider.sgm.eventos.ProtocoloListener;
import br.com.schneider.sgm.eventos.UPSListener;
import br.com.schneider.sgm.gui.InterfaceGrafica;
import br.com.schneider.sgm.historico.Historico;
import br.com.schneider.sgm.historico.HistoricoConsumo;
import br.com.schneider.sgm.internacionalizacao.Idioma;
import br.com.schneider.sgm.log.LogControl;
import br.com.schneider.sgm.persistencia.Persistencia;
import br.com.schneider.sgm.protocolo.ProtocoloPS;
import br.com.schneider.sgm.protocolo.ProtocoloRhino;
import br.com.schneider.sgm.protocolo.ProtocoloSolis;
import br.com.schneider.sgm.protocolo.ProtocoloUPS;
import br.com.schneider.sgm.rmi.ClienteRMI;
import br.com.schneider.sgm.rmi.servicoso.ServicoWin;
import br.com.schneider.sgm.serial.DriverSerial;
import br.com.schneider.sgm.servico.BatTestHandler;
import br.com.schneider.sgm.servico.ExecutaAcaoRede;
import br.com.schneider.sgm.servico.Mensagens;
import br.com.schneider.sgm.servico.SalvaConsumo;
import br.com.schneider.sgm.servico.SalvaEventos;
import br.com.schneider.sgm.snmp.AgenteSGM;
import br.com.schneider.sgm.ups.AbstractUPS;
import br.com.schneider.sgm.ups.UPSDataObject;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JOptionPane;
import javax.swing.Timer;

public class Controle
implements ProtocoloListener,
UPSListener,
ActionListener,
BatTesteListener {
    private static final String FILENAME_CONSUMO_XML = "consumo.xml";
    private static final String FILENAME_EVENTOS_XML = "eventos.xml";
    private static final String FILENAME_ALARMES_XML = "alarmes.xml";
    public static final int SOLIS = 1;
    public static final int RHINO = 2;
    public static final int STAY = 3;
    public static final int SOLIS_LI_700 = 169;
    public static final int SOLIS_M11 = 171;
    public static final int SOLIS_M15 = 175;
    public static final int SOLIS_M14 = 174;
    public static final int SOLIS_M13 = 173;
    public static final int SOLISDC_M14 = 201;
    public static final int SOLISDC_M13 = 206;
    public static final int SOLISDC_M15 = 207;
    public static final int CABECALHO_RHINO = 194;
    public static final int PS800 = 185;
    public static final int STAY1200_USB = 186;
    public static final int PS350_CII = 184;
    public static final int PS2200 = 187;
    public static final int PS2200_22 = 188;
    public static final int STAY700_USB = 189;
    public static final int BZ1500 = 190;
    private static final String version = "4.0";
    private int familiaUPS;
    private int modeloUPS;
    private ProtocoloUPS protocolo;
    private String nomeUPS;
    private String nomePCUPS;
    private boolean falhaCom;
    private boolean temperaturaElevada;
    private boolean usandoSomenteBateria;
    private boolean cargaElevada;
    private boolean bateriaBaixa;
    private boolean redeFalha;
    protected boolean primeiraExecucao = true;
    private boolean flagShutFimAut;
    private boolean shutdownTempoFalha = false;
    private AbstractUPS ups;
    private int eventoGatilho;
    private String caminhoScript;
    private DecimalFormat formatador = new DecimalFormat("00");
    private int autonomiaMinima;
    private int expansorBateria;
    private int tempoFalha = 50000;
    private String idioma;
    private String porta;
    private String[] destinatarios;
    private String remetente;
    private String enderecoSMTP;
    private int portaSMTP;
    private boolean autenticacao;
    private String usuario;
    private String senha;
    private HistoricoConsumo histCos;
    private Evento[] eventos;
    private LogControl valuesLog;
    private Vector<Evento> vetorEventos = new Vector();
    private boolean[][] mensagens;
    private int horaDesligar;
    private int minutoDesligar;
    private int horaLigar;
    private int minutoLigar;
    private int horaDesligarAgendada;
    private int minutoDesligarAgendado;
    private boolean[] programacao = new boolean[7];
    private Timer timerCom;
    private int delayTimerCom = 500000;
    private Timer timerShut;
    private Timer timerFalha;
    private String sistemaOperacional;
    protected Persistencia persistencia;
    private Communication driver;
    private InterfaceGrafica gui;
    private ControleListener[] ouvintesControle;
    private BuscaParametrosXML parametrosXML;
    private AgenteSGM agenteSNMP;
    private String enderecoIPLocal;
    private Historico historicoEventos;
    private int contConsumo;
    private BatTestHandler autoTesteHandler;
    private float consumo;
    private boolean flagShutdown;
    public ExecutaAcaoRede executaAcaoRede;
    private boolean bateriaBaixaScript = false;
    private boolean execucaoViaPrompt = false;
    protected String caminhoAppDataService = "";

    public Controle() {
        this.initControle();
    }

    public Controle(String caminhoAppDataService) {
        this.caminhoAppDataService = caminhoAppDataService;
    }

    public void initControle() {
        this.sistemaOperacional = System.getProperty("os.name").toLowerCase();
        this.contConsumo = 0;
        if (this.isGui()) {
            if (this.sistemaOperacional.indexOf("windows") >= 0) {
                new ServicoWin().parar();
            } else {
                new ClienteRMI().fecharPortaUsbUtilizadaPeloServico();
            }
        }
        if (this.isServicoSO()) {
            PathConfig.setPath(this.caminhoAppDataService);
        }
        this.historicoEventos = new Historico(String.valueOf(PathConfig.getPathXML()) + FILENAME_EVENTOS_XML);
        this.histCos = new HistoricoConsumo(String.valueOf(PathConfig.getPathXML()) + FILENAME_CONSUMO_XML);
        this.flagShutdown = false;
        this.driver = new DriverSerial();
        this.timerCom = new Timer(this.delayTimerCom, this);
        this.timerShut = new Timer(1000, this);
        this.timerFalha = new Timer(this.tempoFalha, this);
        this.parametrosXML = new BuscaParametrosXML();
        this.persistencia = new Persistencia(PathConfig.getPathXML());
        Evento[] evts = this.importArrayEvento();
        if (evts != null) {
            this.putEventos(this.importArrayEvento());
        } else {
            GregorianCalendar calendar = new GregorianCalendar();
            this.historicoEventos.criaArquivo();
            Evento evt = new Evento("Ok", calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(5), calendar.get(2) + 1, calendar.get(1));
            this.putEventos(evt);
            Evento[] evtss = new Evento[]{evt};
            this.salvaEventos(evtss);
        }
        this.valuesLog = new LogControl(this);
        if (this.isGui()) {
            this.gui = new InterfaceGrafica("Figuras" + File.separator, this, this.getPortas());
        }
        this.ouvintesControle = new ControleListener[10];
        this.autoTesteHandler = new BatTestHandler(this, this);
        this.autoTesteHandler.setAutoTesteHabilitado(this.persistencia.getAutoTesteEnabled());
        this.autoTesteHandler.setHoraTeste(this.persistencia.getHoraTeste());
        this.autoTesteHandler.setMinutoTeste(this.persistencia.getMinutoTeste());
        this.autoTesteHandler.setPeriodoAutoTeste(this.persistencia.getPeriodoTeste());
        Thread threadAutoTesteHandler = new Thread(this.autoTesteHandler);
        threadAutoTesteHandler.start();
        if (this.isGui()) {
            this.addControleListener(this.gui);
        }
        this.addControleListener(this.valuesLog);
        this.parametrosXML.setNomeDocumento(String.valueOf(PathConfig.getPathXML()) + FILENAME_ALARMES_XML);
        Evento.listaAlarmes = this.parametrosXML.configuraAlarmes();
        if (this.isGui()) {
            this.gui.setEventos(Evento.listaAlarmes);
        }
        if (this.isGui()) {
            this.gui.lePersistencia();
        }
        if (this.isServicoSO()) {
            this.lePersistenciaComDadosUteisParaOservico();
        }
        this.valuesLog.setLogEnabled(this.persistencia.getModoLogging());
        this.programacao = new boolean[7];
        if (this.isModoRemoto()) {
            this.executaAcaoRede = new ExecutaAcaoRede();
            this.executaAcaoRede.setPortaEscuta(this.getPortaRemota());
            this.executaAcaoRede.start();
        }
        if (this.isGui()) {
            try {
                this.enderecoIPLocal = InetAddress.getLocalHost().getHostAddress();
                try {
                    this.agenteSNMP = new AgenteSGM(new File("AgenteSGMBC.cfg"), new File("AgenteSGMConfig.cfg"), String.valueOf(this.enderecoIPLocal) + "/" + this.getPortaPedidos(), this, this.histCos);
                    this.agenteSNMP.init();
                    this.agenteSNMP.loadConfig(2);
                    this.agenteSNMP.run();
                    this.agenteSNMP.getTimerPerMIB().start();
                    this.addControleListener(this.agenteSNMP);
                }
                catch (IOException ex) {
                    System.err.println(ex.getMessage());
                    ex.printStackTrace();
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                    e.printStackTrace();
                }
            }
            catch (UnknownHostException uhe) {
                System.err.println(uhe.getMessage());
                uhe.printStackTrace();
            }
        }
    }

    protected boolean isGui() {
        return !this.execucaoViaPrompt;
    }

    protected boolean isServicoSO() {
        return this.execucaoViaPrompt;
    }

    protected void setServicoSO(boolean execucaoViaPrompt) {
        this.execucaoViaPrompt = execucaoViaPrompt;
    }

    private void lePersistenciaComDadosUteisParaOservico() {
        this.setIdioma((String)this.persistencia.getIdioma());
        if (this.getIdioma().toUpperCase().startsWith("PORTUGU")) {
            Idioma.setIdiomaPortugues();
        } else {
            Idioma.setIdiomaIngles();
        }
        this.setAutonomiaMinima(this.persistencia.getAutonoMinima());
        this.setFlagShutFimAut(this.persistencia.isFlagShutFimAut());
        this.setTempoFalha(this.persistencia.getTempoFalhaEletrica());
        this.setShutdownTempoFalha(this.persistencia.isFlagShutFalhaEletrica());
    }

    public void pedidoDumpping() {
        this.protocolo.pedidoDumpping();
    }

    public void setLocalAdress(String local) {
        try {
            try {
                this.agenteSNMP.getSession().close();
                this.agenteSNMP.setLocalAddress(local);
                this.agenteSNMP.getTimerPerMIB().stop();
                this.agenteSNMP = null;
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
                try {
                    AgenteSGM agente;
                    this.agenteSNMP = agente = new AgenteSGM(new File("AgenteSGMBC.cfg"), new File("AgenteSGMConfig.cfg"), String.valueOf(this.enderecoIPLocal) + "/" + this.getPortaPedidos(), this, this.histCos);
                    this.agenteSNMP.init();
                    this.agenteSNMP.loadConfig(2);
                    this.agenteSNMP.run();
                    this.agenteSNMP.getTimerPerMIB().start();
                    this.addControleListener(this.agenteSNMP);
                }
                catch (IOException ex) {
                    System.err.println(ex.getMessage());
                    ex.printStackTrace();
                }
                catch (Exception e2) {
                    System.err.println(e2.getMessage());
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                AgenteSGM agente;
                this.agenteSNMP = agente = new AgenteSGM(new File("AgenteSGMBC.cfg"), new File("AgenteSGMConfig.cfg"), String.valueOf(this.enderecoIPLocal) + "/" + this.getPortaPedidos(), this, this.histCos);
                this.agenteSNMP.init();
                this.agenteSNMP.loadConfig(2);
                this.agenteSNMP.run();
                this.agenteSNMP.getTimerPerMIB().start();
                this.addControleListener(this.agenteSNMP);
            }
            catch (IOException ex) {
                System.err.println(ex.getMessage());
                ex.printStackTrace();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public boolean setComunidadeLeitura(String nova, String antiga) {
        return this.agenteSNMP.changeReadOnlyComunityString(antiga, nova);
    }

    public boolean setConfigTraps(String ipGerente, int portaEnvio, int versao, String protocoloTransporte, String comEscrita) {
        return this.agenteSNMP.changeConfigTraps(ipGerente, portaEnvio, versao, protocoloTransporte, comEscrita);
    }

    public boolean setComunidadeEscrita(String nova, String antiga) {
        return this.agenteSNMP.changeReadWriteComunityString(antiga, nova);
    }

    public void addControleListener(ControleListener ouvinteControle) {
        int i = 0;
        while (this.ouvintesControle[i] != null && i < this.ouvintesControle.length) {
            ++i;
        }
        this.ouvintesControle[i] = ouvinteControle;
    }

    public void notificaOuvintesControle(int tipoNotificacao) {
        int i = 0;
        while (this.ouvintesControle[i] != null && i < this.ouvintesControle.length) {
            switch (tipoNotificacao) {
                case 1: {
                    this.ouvintesControle[i].notificaDados();
                    break;
                }
                case 2: {
                    this.ouvintesControle[i].notificaFalhaCom();
                    break;
                }
                case 3: {
                    this.ouvintesControle[i].notificaRetornoCom();
                    break;
                }
                case 4: {
                    this.ouvintesControle[i].notificaFalhaRede();
                    break;
                }
                case 5: {
                    this.ouvintesControle[i].notificaRetornoRede();
                    break;
                }
                case 6: {
                    this.ouvintesControle[i].notificaBateriaBaixa();
                    if (this.bateriaBaixaScript) break;
                    this.bateriaBaixaScript = true;
                    this.verificaArquivoLote(new Evento[]{new Evento("BATERIA_BAIXA", 0, 0, 0, 0, 0, 0)});
                    break;
                }
                case 7: {
                    this.ouvintesControle[i].notificaBateriaNormal();
                    break;
                }
                case 8: {
                    this.ouvintesControle[i].notificaCargaElevada();
                    break;
                }
                case 9: {
                    this.ouvintesControle[i].notificaCargaNormal();
                    break;
                }
                case 10: {
                    this.ouvintesControle[i].notificaTemperaturaElevada();
                    break;
                }
                case 11: {
                    this.ouvintesControle[i].notificaTemperaturaNormal();
                    break;
                }
                case 12: {
                    this.ouvintesControle[i].notificaUsandoBateria();
                    break;
                }
                case 13: {
                    this.ouvintesControle[i].notificaNaoUsaBateria();
                    break;
                }
                case 14: {
                    this.ouvintesControle[i].notificaComunicacao();
                }
            }
            ++i;
        }
    }

    public String getVersaoSoftware() {
        return version;
    }

    public boolean configuraUPSEtapa1(int familiaUPS, String porta) {
        if (!this.setFamiliaUPS(familiaUPS)) {
            return false;
        }
        if (this.isServicoSO() && porta != null && this.sistemaOperacional.indexOf("windows") >= 0) {
            porta = porta.replaceAll("[^a-zA-Z0-9]", "");
            porta = porta.replaceAll("/", "");
            porta = porta.replace(".", "");
        }
        if (!this.setPorta(porta)) {
            return false;
        }
        if (!this.timerCom.isRunning()) {
            this.timerCom.start();
        } else {
            this.timerCom.restart();
        }
        return true;
    }

    public boolean configuraUPSEtapa2() {
        this.modeloUPS = this.protocolo.getCabecalhoPacote();
        switch (this.modeloUPS) {
            case 194: {
                this.ups = new Rhino(this.protocolo);
                break;
            }
            case 201: 
            case 206: 
            case 207: {
                this.ups = new SolisDCM15(this.protocolo);
                break;
            }
            case 173: {
                this.ups = new SolisM13(this.protocolo);
                break;
            }
            case 174: {
                this.ups = new SolisM14(this.protocolo);
                break;
            }
            case 175: {
                this.ups = new SolisM15(this.protocolo);
                break;
            }
            case 171: {
                this.ups = new SolisM11(this.protocolo);
                break;
            }
            case 169: {
                this.ups = new SolisLI700(this.protocolo);
                break;
            }
            case 185: {
                this.ups = new PS800((ProtocoloPS)this.protocolo);
                break;
            }
            case 184: {
                this.ups = new PS350_CII((ProtocoloPS)this.protocolo);
                break;
            }
            case 186: {
                this.ups = new Stay1200_USB((ProtocoloPS)this.protocolo);
                break;
            }
            case 187: {
                this.ups = new PS2200((ProtocoloPS)this.protocolo);
                break;
            }
            case 188: {
                this.ups = new PS2200_22((ProtocoloPS)this.protocolo);
                break;
            }
            case 189: {
                this.ups = new Stay700_USB((ProtocoloPS)this.protocolo);
                break;
            }
            case 190: {
                this.ups = new BZ1500((ProtocoloPS)this.protocolo);
                break;
            }
            default: {
                this.protocolo.addProtocoloListener(null);
                if (this.isGui()) {
                    this.gui.mostraPopUp("Erro_de_configuracao__Verifique_a_familia_de_UPS_selecionada");
                }
                return false;
            }
        }
        this.protocolo.addProtocoloListener(this.ups);
        this.ups.addUPSListener(this);
        this.ups.notifica();
        this.ups.setExpansorBateria(this.expansorBateria);
        this.notificaControle();
        if (this.modeloUPS != 194) {
            this.atualizaCalendarioRelogio();
        }
        this.notificaOuvintesControle(14);
        if (!this.timerShut.isRunning()) {
            this.timerShut.start();
        }
        return true;
    }

    public boolean atualizaCalendarioRelogio() {
        GregorianCalendar horaAtual = new GregorianCalendar();
        return this.ups.configuraCalendarioRelogio(horaAtual.get(7) - 1, horaAtual.get(5), horaAtual.get(2) + 1, horaAtual.get(1), horaAtual.get(13), horaAtual.get(12), horaAtual.get(11));
    }

    public void desligaUPS2() {
        JOptionPane.showMessageDialog(null, "desligaUPS(): " + new Date());
    }

    public void desligaUPS() {
        if (this.executaAcaoRede != null) {
            try {
                this.executaAcaoRede.encerraClientes();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.encerraSO();
    }

    public void religaUPS2() {
        JOptionPane.showMessageDialog(null, "2 - religaUPS - EXECUTADO!!!!!!!!!!!!!!!!!");
    }

    public void religaUPS() {
        this.ups.shutdownReligamento();
        try {
            this.executaAcaoRede.encerraClientes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.encerraSO();
    }

    public void encerraSO() {
        if (this.sistemaOperacional.indexOf("windows") >= 0) {
            try {
                try {
                    Runtime.getRuntime().exec("rundll.exe user.exe,ExitWindows");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Runtime.getRuntime().exec("shutdown /s /f /t 30 /c \"SGM - Software de Gerenciamento Microsol.\"");
                this.flagShutdown = true;
            }
            catch (IOException ioe) {
                System.err.println(ioe.getMessage());
                ioe.printStackTrace();
            }
        }
        if (this.sistemaOperacional.indexOf("linux") >= 0) {
            try {
                Runtime.getRuntime().exec("shutdown -h 1 SGM - Software de Gerenciamento Microsol.");
                this.flagShutdown = true;
            }
            catch (IOException ioe) {
                System.err.println(ioe.getMessage());
                ioe.printStackTrace();
            }
        }
    }

    @Override
    public void notifica() {
        this.configuraUPSEtapa2();
    }

    public void verificaArquivoLote(Evento[] evts) {
        if (evts != null) {
            boolean naoOcorreu = true;
            int i = 0;
            this.setEventoGatilho(this.getEventoPersistencia());
            while (naoOcorreu && evts[i] != null) {
                if (evts[i].getTipo().equals(Evento.listaAlarmes[this.eventoGatilho]) || (evts[i].getTipo().equalsIgnoreCase("SUBTENSAO_ENTRADA") || evts[i].getTipo().equalsIgnoreCase("SOBRETENSAO_ENTRADA")) && Evento.listaAlarmes[this.eventoGatilho].equalsIgnoreCase("FALHA_NA_REDE")) {
                    naoOcorreu = false;
                    if (this.persistencia.getScript() != null) {
                        this.executaScript();
                    }
                }
                if (++i != evts.length) continue;
                naoOcorreu = false;
            }
        }
    }

    private void executaScript() {
        block7: {
            if (this.sistemaOperacional.indexOf("windows") >= 0) {
                try {
                    Runtime.getRuntime().exec("cmd /c \"" + this.persistencia.getScript() + "\"");
                }
                catch (IOException ioe) {
                    System.err.println(ioe.getMessage());
                    ioe.printStackTrace();
                    if (this.isGui()) {
                        this.gui.mostraPopUp("Erro_executar_script");
                    }
                    break block7;
                }
            }
            if (this.sistemaOperacional.indexOf("linux") >= 0) {
                try {
                    Runtime.getRuntime().exec(this.persistencia.getScript());
                }
                catch (IOException ioe) {
                    System.err.println(ioe.getMessage());
                    ioe.printStackTrace();
                    if (!this.isGui()) break block7;
                    this.gui.mostraPopUp("Erro_executar_script");
                }
            }
        }
    }

    public void enviaEmail(String mensagem) {
        Mensagens email = new Mensagens(mensagem, this.persistencia.getNomeUPS(), String.valueOf(this.formatador.format(this.ups.getHora())) + ":" + this.formatador.format(this.ups.getMinutos()) + ":" + this.formatador.format(this.ups.getSegundos()), this.persistencia.getDestinatarios(), this.persistencia.getRemetente(), this.persistencia.getEnderecoSMTP(), this.persistencia.getPortaSMTP(), this.persistencia.isFlagAutentic(), this.persistencia.getUsuario(), this.persistencia.getSenha(), (String)this.persistencia.getIdioma());
        email.setDaemon(true);
        if (this.isGui()) {
            email.setGui(this.gui);
        }
        email.setMensagemErro("Erro_ao_enviar_o_Email");
        email.start();
    }

    public void configuraEmail(String[] destinatarios, String remetente, String enderecoSMTP, int portaSMTP, boolean autenticacao, String usuario, String senha) {
        this.destinatarios = destinatarios;
        this.remetente = remetente;
        this.enderecoSMTP = enderecoSMTP;
        this.portaSMTP = portaSMTP;
        this.autenticacao = autenticacao;
        this.usuario = usuario;
        this.senha = senha;
        this.persistencia.setDestinatarios(destinatarios);
        this.persistencia.setRemetente(remetente);
        this.persistencia.setEnderecoSMTP(enderecoSMTP);
        this.persistencia.setPortaSMTP(portaSMTP);
        this.persistencia.setFlagAutentic(autenticacao);
        this.persistencia.setUsuario(usuario);
        this.persistencia.setSenha(senha);
        this.persistencia.salvaConf();
    }

    public boolean programaSemana(boolean[] dias, int horaLigar, int minutoLigar, int horaDesligar, int minutoDesligar) {
        this.programacao = dias;
        this.horaLigar = horaLigar;
        this.minutoLigar = minutoLigar;
        this.horaDesligar = horaDesligar;
        this.minutoDesligar = minutoDesligar;
        if (minutoDesligar >= 5) {
            this.minutoDesligarAgendado = minutoDesligar - 5;
            this.horaDesligarAgendada = horaDesligar;
        } else {
            this.minutoDesligarAgendado = minutoDesligar - 5 + 60;
            this.horaDesligarAgendada = horaDesligar - 1;
        }
        return this.programa();
    }

    public boolean programa() {
        GregorianCalendar horaAtual = new GregorianCalendar();
        return this.ups.programa(this.programacao, this.horaLigar, this.minutoLigar, this.horaDesligar, this.minutoDesligar, horaAtual.get(7) - 1, horaAtual.get(5), horaAtual.get(2) + 1, horaAtual.get(1), horaAtual.get(13), horaAtual.get(12), horaAtual.get(11));
    }

    public void desligaFimAutonomia() {
        if (this.flagShutFimAut && this.ups.getAutonomiaBateria() <= this.autonomiaMinima && !this.ups.isModoRede()) {
            this.desligaUPS();
        }
    }

    public static void salvaErro(String str) {
        try {
            ObjectOutputStream output = new ObjectOutputStream(new FileOutputStream(new File("erros.txt")));
            output.writeObject(str);
            output.flush();
            output.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public void salvaEventos(Evento[] evts) {
        SalvaEventos salvaEventos = new SalvaEventos(evts, this.historicoEventos);
        ExecutorService threadExecutor = Executors.newFixedThreadPool(1);
        threadExecutor.execute(salvaEventos);
        threadExecutor.shutdown();
    }

    public boolean excluirEvento(int index) {
        Evento[] temp = this.getArrayEventos();
        if (this.historicoEventos.removerEvento(temp[index], temp[index].getMes(), temp[index].getAno())) {
            this.removeEvento(temp[index]);
            return true;
        }
        return false;
    }

    public boolean excluirTodosEventos() {
        this.historicoEventos.criaArquivo();
        this.removeAllEvento();
        return true;
    }

    public void salvaConsumo() {
        ++this.contConsumo;
        this.consumo += this.getPotenciaReal() / 3600000.0f;
        if (this.contConsumo >= 3600) {
            if (this.isGui()) {
                SalvaConsumo salvaConsumo = new SalvaConsumo(this.consumo, this.gui.getPainelGraficos());
                ExecutorService threadExecutor = Executors.newFixedThreadPool(1);
                threadExecutor.execute(salvaConsumo);
            }
            this.consumo = 0.0f;
            this.contConsumo = 0;
        }
    }

    private void putEventos(Evento e) {
        if (e != null) {
            this.vetorEventos.add(e);
        }
    }

    public void putEventos(Evento[] e) {
        if (e != null) {
            int i = 0;
            while (i < e.length) {
                if (e[i] instanceof Evento) {
                    this.vetorEventos.add(e[i]);
                }
                ++i;
            }
        }
    }

    private boolean removeEvento(Evento evento) {
        return this.vetorEventos.remove(evento);
    }

    private boolean removeAllEvento() {
        this.vetorEventos.clear();
        return true;
    }

    public Evento[] getArrayEventos() {
        Evento[] temp = new Evento[this.vetorEventos.size()];
        int i = 0;
        while (i < this.vetorEventos.size()) {
            if (this.vetorEventos.get(i) instanceof Evento) {
                temp[i] = this.vetorEventos.get(i);
            }
            ++i;
        }
        return temp;
    }

    private Evento[] importArrayEvento() {
        return this.historicoEventos.getEventos();
    }

    @Override
    public void notificaControle() {
        this.notificaOuvintesControle(1);
        this.programacao = this.ups.getDiasSemanaProgramados();
        this.horaDesligar = this.ups.getHoraDesligar();
        this.minutoDesligar = this.ups.getMinutoDesligar();
        this.horaLigar = this.ups.getHoraLigar();
        this.minutoLigar = this.ups.getMinutoLigar();
        if (this.minutoDesligar >= 5) {
            this.minutoDesligarAgendado = this.minutoDesligar - 5;
            this.horaDesligarAgendada = this.horaDesligar;
        } else {
            this.minutoDesligarAgendado = this.minutoDesligar - 5 + 60;
            this.horaDesligarAgendada = this.horaDesligar - 1;
        }
        this.timerCom.restart();
        if (this.falhaCom) {
            this.falhaCom = false;
            this.atualizaCalendarioRelogio();
            this.notificaOuvintesControle(3);
            if (this.persistencia != null && this.persistencia.getMensagens()[5][0]) {
                this.enviaEmail(ResourceBundle.getBundle(Idioma.getIdioma()).getString("Retorno_da_comunicacao_com_UPS__Horario"));
            }
        }
        if (!this.ups.isModoRede() && !this.redeFalha) {
            this.redeFalha = true;
            if (this.shutdownTempoFalha) {
                if (!this.timerFalha.isRunning()) {
                    this.timerFalha.start();
                } else {
                    this.timerFalha.restart();
                }
            }
            this.notificaOuvintesControle(4);
            if (this.persistencia != null && this.persistencia.getMensagens()[0][0]) {
                this.enviaEmail(ResourceBundle.getBundle(Idioma.getIdioma()).getString("Falta_de_energia"));
            }
        } else if (this.ups.isModoRede() && this.redeFalha) {
            this.redeFalha = false;
            this.notificaOuvintesControle(5);
            if (this.persistencia != null && this.persistencia.getMensagens()[0][0]) {
                this.enviaEmail(ResourceBundle.getBundle(Idioma.getIdioma()).getString("Retorno_de_energia"));
            }
        }
        if (this.ups.isBateriaBaixa() && !this.bateriaBaixa) {
            this.bateriaBaixa = true;
            this.notificaOuvintesControle(6);
            if (this.persistencia != null && this.persistencia.getMensagens()[1][0]) {
                this.enviaEmail(ResourceBundle.getBundle(Idioma.getIdioma()).getString("A_bateria_esta_fraca"));
            }
            this.bateriaBaixaScript = false;
        } else if (!this.ups.isBateriaBaixa() && this.bateriaBaixa) {
            this.bateriaBaixa = false;
            this.notificaOuvintesControle(7);
            if (this.persistencia != null && this.persistencia.getMensagens()[1][0]) {
                this.enviaEmail(ResourceBundle.getBundle(Idioma.getIdioma()).getString("A_bateria_esta_normal"));
            }
        }
        if (this.ups.isCargaElevada() && !this.cargaElevada) {
            this.cargaElevada = true;
            this.notificaOuvintesControle(8);
            if (this.persistencia != null && this.persistencia.getMensagens()[2][0]) {
                this.enviaEmail(ResourceBundle.getBundle(Idioma.getIdioma()).getString("A_carga_esta_elevada"));
            }
        } else if (!this.ups.isCargaElevada() && this.cargaElevada) {
            this.cargaElevada = false;
            this.notificaOuvintesControle(9);
            if (this.persistencia != null && this.persistencia.getMensagens()[2][0]) {
                this.enviaEmail(ResourceBundle.getBundle(Idioma.getIdioma()).getString("A_carga_esta_normal"));
            }
        }
        if (this.ups.isTemperaturaElevada() && !this.temperaturaElevada) {
            this.temperaturaElevada = true;
            this.notificaOuvintesControle(10);
            if (this.persistencia != null && this.persistencia.getMensagens()[3][0]) {
                this.enviaEmail(ResourceBundle.getBundle(Idioma.getIdioma()).getString("A_temperatura_esta_elevada"));
            }
        } else if (!this.ups.isTemperaturaElevada() && this.temperaturaElevada) {
            this.temperaturaElevada = false;
            this.notificaOuvintesControle(11);
            if (this.persistencia != null && this.persistencia.getMensagens()[3][0]) {
                this.enviaEmail(ResourceBundle.getBundle(Idioma.getIdioma()).getString("A_temperatura_esta_normal"));
            }
        }
        if (this.ups.isUsandoSomenteBateria() && !this.usandoSomenteBateria) {
            this.usandoSomenteBateria = true;
            this.notificaOuvintesControle(12);
            if (this.persistencia != null && this.persistencia.getMensagens()[4][0]) {
                this.enviaEmail(ResourceBundle.getBundle(Idioma.getIdioma()).getString("A_bateria_esta_em_uso"));
            }
        } else if (!this.ups.isUsandoSomenteBateria() && this.usandoSomenteBateria) {
            this.usandoSomenteBateria = false;
            this.notificaOuvintesControle(13);
            if (this.persistencia != null && this.persistencia.getMensagens()[4][0]) {
                this.enviaEmail(ResourceBundle.getBundle(Idioma.getIdioma()).getString("A_bateria_nao_esta_mais_em_uso"));
            }
        }
        this.eventos = this.ups.getEventos();
        if (this.eventos != null) {
            this.salvaEventos(this.eventos);
            this.putEventos(this.eventos);
            this.verificaArquivoLote(this.eventos);
        }
        this.salvaConsumo();
        this.desligaFimAutonomia();
    }

    public void addEventos(Evento[] eventos) {
        this.salvaEventos(eventos);
        this.putEventos(eventos);
        this.verificaArquivoLote(eventos);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.timerShut && this.programacao[this.ups.getDiaSemana()] && (this.ups.getHora() == this.horaDesligarAgendada || this.ups.getHora() == this.horaDesligar) && this.ups.getMinutos() >= this.minutoDesligarAgendado && this.ups.getMinutos() <= this.minutoDesligar) {
            this.desligaUPS();
        }
        if (ae.getSource() == this.timerCom) {
            this.notificaOuvintesControle(2);
            this.protocolo.setModoContinuo();
            if (this.persistencia != null && this.persistencia.getMensagens()[5][0]) {
                this.enviaEmail(String.valueOf(ResourceBundle.getBundle(Idioma.getIdioma()).getString("Sem_comunicacao_com_o_UPS__Horario")) + this.formatador.format(this.getHora()) + ":" + this.formatador.format(this.getMinutos()));
            }
            this.falhaCom = true;
            this.driver.restart();
            this.timerCom.stop();
        }
        if (ae.getSource() == this.timerFalha && !this.ups.isModoRede() && this.redeFalha && this.shutdownTempoFalha) {
            this.desligaUPS();
        }
    }

    public void fechaPersistenciaServico() {
        this.persistencia.salvaConf();
        this.persistencia.setSgmConf(null);
        this.persistencia = null;
    }

    public void abrePersistenciaServico() {
        this.persistencia = new Persistencia(PathConfig.getPathXML());
    }

    public void encerraAplicativo(Object idioma, int evento, String script, boolean[][] mensagens, int expBat, String nomeUPS, String smtp, boolean flagAuten, String usuario, String senha, String remetente, String[] destinatario, int portaSMTP, int portaPedidos, String comunaLeitura, String comunaEscrita, String enderecoGerente, int portaEnvio, int vSnmp, int protocolo, int autonomia, int falhaEletrica, int portaRemota, boolean modo, double valorKW, boolean shutFim, boolean falha, String provedorEscolhido) {
        if (this.persistencia.getFamilia() != 0) {
            if (this.isGui()) {
                SalvaConsumo salvaConsumo = new SalvaConsumo(this.consumo, this.gui.getPainelGraficos());
                ExecutorService threadExecutor = Executors.newFixedThreadPool(1);
                threadExecutor.execute(salvaConsumo);
                threadExecutor.shutdown();
            }
            this.persistencia.setFamilia(this.familiaUPS);
            this.persistencia.setModeloUPS(this.modeloUPS);
            this.persistencia.setPorta(this.driver.getNomePortaAtual());
            this.persistencia.setIdioma(idioma);
            this.persistencia.setEvento(evento);
            this.persistencia.setScript(script);
            this.persistencia.setMensagens(mensagens);
            this.persistencia.setExpansorBateria(expBat);
            this.persistencia.setNomeUPS(nomeUPS);
            this.persistencia.setEnderecoSMTP(smtp);
            this.persistencia.setFlagAutentic(flagAuten);
            this.persistencia.setUsuario(usuario);
            this.persistencia.setSenha(senha);
            this.persistencia.setRemetente(remetente);
            this.persistencia.setDestinatarios(destinatario);
            this.persistencia.setPortaSMTP(portaSMTP);
            this.persistencia.setPortaPedidos(portaPedidos);
            this.persistencia.setComunidadeLeitura(comunaLeitura);
            this.persistencia.setComunidadeEscrita(comunaEscrita);
            this.persistencia.setEnderecoGerente(enderecoGerente);
            this.persistencia.setPortaEnvio(portaEnvio);
            this.persistencia.setVSNMP(vSnmp);
            this.persistencia.setProtocoloTransporte(protocolo);
            this.persistencia.setAutonoMinima(autonomia);
            this.persistencia.setFlagShutFimAut(shutFim);
            this.persistencia.setFlagShutFalhaEletrica(falha);
            this.persistencia.setTempoFalhaEletrica(falhaEletrica);
            this.persistencia.setValorKw(valorKW);
            this.persistencia.setProvedorEscolhido(provedorEscolhido);
            this.salvaPortaRemota(portaRemota);
            this.salvaModoRemoto(modo);
            this.persistencia.salvaConf();
        }
        if (this.isGui()) {
            if (this.sistemaOperacional.indexOf("windows") >= 0) {
                new ServicoWin().iniciar();
            } else {
                new ClienteRMI().abrirPortaUsbDoServico(this);
            }
        }
        System.exit(0);
    }

    public void salvaPersistenciaSNMP(int portaPedidos, String comunaLeitura, String comunaEscrita, String enderecoGerente, int portaEnvio, int vSnmp, int protocolo) {
        this.persistencia.setPortaPedidos(portaPedidos);
        this.persistencia.setComunidadeLeitura(comunaLeitura);
        this.persistencia.setComunidadeEscrita(comunaEscrita);
        this.persistencia.setEnderecoGerente(enderecoGerente);
        this.persistencia.setPortaEnvio(portaEnvio);
        this.persistencia.setVSNMP(vSnmp);
        this.persistencia.setProtocoloTransporte(protocolo);
        this.persistencia.salvaConf();
    }

    public void salvaMensagens(boolean[][] mensagens) {
        this.persistencia.setMensagens(mensagens);
        this.persistencia.salvaConf();
    }

    public void salvaPortaSMTP(int porta) {
        this.persistencia.setPortaSMTP(porta);
        this.persistencia.salvaConf();
    }

    public void salvaModoLogging(boolean b) {
        this.valuesLog.setLogEnabled(b);
        this.persistencia.setModoLogging(b);
        this.persistencia.salvaConf();
    }

    public void salvaPortaPedidos(int portaPedidos) {
        this.persistencia.setPortaPedidos(portaPedidos);
        this.persistencia.salvaConf();
    }

    public void salvaComunidadeLeitura(String comunaLeitura) {
        this.persistencia.setComunidadeLeitura(comunaLeitura);
        this.persistencia.salvaConf();
    }

    public void salvaComunidadeEscrita(String comunaEscrita) {
        this.persistencia.setComunidadeEscrita(comunaEscrita);
        this.persistencia.salvaConf();
    }

    public void salvaEnderecoGerente(String enderecoGerente) {
        this.persistencia.setEnderecoGerente(enderecoGerente);
        this.persistencia.salvaConf();
    }

    public void salvaPortaEnvio(int portaEnvio) {
        this.persistencia.setPortaEnvio(portaEnvio);
        this.persistencia.salvaConf();
    }

    public void salvaVSnmp(int vSnmp) {
        this.persistencia.setVSNMP(vSnmp);
        this.persistencia.salvaConf();
    }

    public void salvaProtocolo(int protocolo) {
        this.persistencia.setProtocoloTransporte(protocolo);
        this.persistencia.salvaConf();
    }

    public void salvaExpansorBateria(int expansor) {
        this.persistencia.setExpansorBateria(expansor);
        this.persistencia.salvaConf();
        this.expansorBateria = expansor;
    }

    public void salvaNomeUPS(String nomeUPS) {
        this.persistencia.setNomeUPS(nomeUPS);
        this.persistencia.salvaConf();
    }

    public void salvaEventoGatilho(int evento) {
        this.persistencia.setEvento(evento);
        this.persistencia.salvaConf();
    }

    public void salvaPortaRemota(int porta) {
        this.persistencia.setPortaRemota(porta);
        this.persistencia.salvaConf();
    }

    public void salvaModoRemoto(boolean modo) {
        this.persistencia.setModoRemoto(modo);
        this.persistencia.salvaConf();
    }

    public void salvaScript(String script) {
        this.persistencia.setScript(script);
        this.persistencia.salvaConf();
    }

    public void salvaVSnmp2(Integer vSnmp) {
        this.persistencia.setVSNMP(vSnmp - 1);
        this.persistencia.salvaConf();
    }

    public void salvaValorKw(double valor) {
        this.persistencia.setValorKw(valor);
        this.persistencia.salvaConf();
    }

    public void salvaProtocolo(String protocolo) {
        if (protocolo.equalsIgnoreCase("UDP")) {
            this.persistencia.setProtocoloTransporte(0);
        } else {
            this.persistencia.setProtocoloTransporte(1);
        }
        this.persistencia.salvaConf();
    }

    public void configuraSGM() {
        this.familiaUPS = this.persistencia.getFamilia();
        this.modeloUPS = this.persistencia.getModeloUPS();
        this.configuraUPSEtapa1(this.familiaUPS, this.persistencia.getPorta());
        this.protocolo.addProtocoloListener(this);
    }

    public void configuraAutoTeste(boolean enable, int hora, int minuto, int periodo) {
        this.autoTesteHandler.setAutoTesteHabilitado(enable);
        this.autoTesteHandler.setHoraTeste(hora);
        this.autoTesteHandler.setMinutoTeste(minuto);
        this.autoTesteHandler.setPeriodoAutoTeste(periodo);
        this.persistencia.setAutoTeste(enable);
        this.persistencia.setHoraTeste(hora);
        this.persistencia.setMinutoTeste(minuto);
        this.persistencia.setPeriodoAutoTeste(periodo);
    }

    public boolean desligaEntrada() {
        return this.ups.desligaEntrada();
    }

    public boolean ligaEntrada() {
        return this.ups.ligaEntrada();
    }

    public boolean desligaSaida() {
        return this.ups.desligaSaida();
    }

    public boolean ligaSaida() {
        return this.ups.ligaSaida();
    }

    public boolean ativaBypass() {
        return this.ups.ativaBypass();
    }

    public boolean desativaBypass() {
        return this.ups.desativaBypass();
    }

    public boolean iniciarAutoteste() {
        return this.ups.iniciarAutoteste();
    }

    public boolean finalizarAutoteste() {
        return this.ups.finalizarAutoteste();
    }

    public void downloadEventos() {
        this.ups.downloadEventos();
    }

    public boolean isTesteExecutando() {
        return this.ups.isTesteExecutando();
    }

    public float getFrequenciaBypass() {
        return this.ups.getFrequenciaBypass();
    }

    public float getTensaoBypass() {
        return this.ups.getTensaoBypass();
    }

    public float getCorrenteBypass() {
        return this.ups.getCorrenteBypass();
    }

    public float getPotenciaBypass() {
        return this.ups.getPotenciaBypass();
    }

    public static void main(String[] args) {
        Controle sgmLite = new Controle();
        if (sgmLite.persistencia.isPrimeiraExec()) {
            sgmLite.primeiraExecucao = true;
        } else {
            sgmLite.primeiraExecucao = false;
            sgmLite.configuraSGM();
        }
    }

    public boolean setFamiliaUPS(int familiaUPS) {
        if (this.driver.getNomePortaAtual() != null && !this.driver.close()) {
            return false;
        }
        switch (familiaUPS) {
            case 1: {
                this.protocolo = new ProtocoloSolis();
                break;
            }
            case 2: {
                this.protocolo = new ProtocoloRhino();
                break;
            }
            case 3: {
                this.protocolo = new ProtocoloPS();
                break;
            }
            default: {
                return false;
            }
        }
        this.familiaUPS = familiaUPS;
        this.driver.addDriverListener(this.protocolo);
        this.protocolo.setComunicador(this.driver);
        this.persistencia.setFamilia(familiaUPS);
        this.protocolo.addProtocoloListener(this);
        return true;
    }

    public void setIdioma(String idioma) {
        this.idioma = idioma;
    }

    public boolean setPorta(String porta) {
        boolean flagOpen;
        String familia;
        this.parametrosXML.setNomeDocumento(String.valueOf(PathConfig.getPathXML()) + "comunicacao.xml");
        String[] parametros = new String[7];
        switch (this.familiaUPS) {
            case 1: {
                familia = "solis";
                break;
            }
            case 2: {
                familia = "rhino";
                break;
            }
            case 3: {
                familia = "stay";
                break;
            }
            default: {
                return false;
            }
        }
        String[] temp = this.parametrosXML.configuraPorta(familia, "serial");
        parametros[0] = porta;
        parametros[1] = temp[0];
        parametros[2] = temp[1];
        parametros[3] = temp[2];
        parametros[4] = temp[3];
        parametros[5] = temp[4];
        parametros[6] = temp[5];
        if (this.driver.getNomePortaAtual() != null) {
            this.driver.close();
        }
        if (flagOpen = this.driver.open(parametros)) {
            if (this.familiaUPS == 2) {
                this.protocolo.pedidoDados();
            }
            return true;
        }
        return false;
    }

    public void setDelayTimerCom(int delayTimerCom) {
        this.delayTimerCom = delayTimerCom;
    }

    public void setEventoGatilho(int eventoGatilho) {
        this.eventoGatilho = eventoGatilho;
    }

    public void setCaminhoScript(String caminhoScript) {
        this.caminhoScript = caminhoScript;
    }

    public void setNomePCUPS(String nomePCUPS) {
        this.nomePCUPS = nomePCUPS;
    }

    public void setTempoFalha(int tempoFalha) {
        this.tempoFalha = tempoFalha * 60 * 1000 / 2;
        this.persistencia.setTempoFalhaEletrica(tempoFalha);
        this.persistencia.salvaConf();
    }

    public void setNomeUPS(String nomeUPS) {
        this.nomeUPS = nomeUPS;
    }

    public void setAutenticacao(boolean autenticacao) {
        this.autenticacao = autenticacao;
    }

    public void setDestinatarios(String[] destinatarios) {
        this.destinatarios = destinatarios;
    }

    public void setEnderecoSMTP(String enderecoSMTP) {
        this.enderecoSMTP = enderecoSMTP;
    }

    public void setPortaSMTP(int portaSMTP) {
        this.portaSMTP = portaSMTP;
    }

    public void setRemetente(String remetente) {
        this.remetente = remetente;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    public void setMensagens(boolean[][] mensagens) {
        this.mensagens = mensagens;
    }

    public void setExpansorBateria(int expansorBateria) {
        if (expansorBateria > 0 && this.ups != null) {
            this.ups.setExpansorBateria(expansorBateria);
        }
        this.expansorBateria = expansorBateria;
    }

    public void setAgenteSNMP(AgenteSGM agenteSNMP) {
        this.agenteSNMP = agenteSNMP;
    }

    public void setBateriaBaixa(boolean bateriaBaixa) {
        this.bateriaBaixa = bateriaBaixa;
    }

    public void setCargaElevada(boolean cargaElevada) {
        this.cargaElevada = cargaElevada;
    }

    public void setDriver(Communication driver) {
        this.driver = driver;
    }

    public void setEnderecoIPLocal(String enderecoIPLocal) {
        this.enderecoIPLocal = enderecoIPLocal;
    }

    public void setEventos(Evento[] eventos) {
        this.eventos = eventos;
    }

    public void setFalhaCom(boolean falhaCom) {
        this.falhaCom = falhaCom;
    }

    public void setFormatador(DecimalFormat formatador) {
        this.formatador = formatador;
    }

    public void setGui(InterfaceGrafica gui) {
        this.gui = gui;
    }

    public void setHistCos(HistoricoConsumo histCos) {
        this.histCos = histCos;
    }

    public void setHoraDesligarAgendada(int horaDesligarAgendada) {
        this.horaDesligarAgendada = horaDesligarAgendada;
    }

    public void setMinutoDesligarAgendado(int minutoDesligarAgendado) {
        this.minutoDesligarAgendado = minutoDesligarAgendado;
    }

    public void setModeloUPS(int modeloUPS) {
        this.modeloUPS = modeloUPS;
    }

    public void setOuvintesControle(ControleListener[] ouvintesControle) {
        this.ouvintesControle = ouvintesControle;
    }

    public void setParametrosXML(BuscaParametrosXML parametrosXML) {
        this.parametrosXML = parametrosXML;
    }

    public void setPersistencia(Persistencia persistencia) {
        this.persistencia = persistencia;
    }

    public void setPrimeiraExecucao(boolean primeiraExecucao) {
        this.primeiraExecucao = primeiraExecucao;
    }

    public void setProgramacao(boolean[] programacao) {
        this.programacao = programacao;
    }

    public void setProtocolo(ProtocoloUPS protocolo) {
        this.protocolo = protocolo;
    }

    public void setRedeFalha(boolean redeFalha) {
        this.redeFalha = redeFalha;
    }

    public void setSistemaOperacional(String sistemaOperacional) {
        this.sistemaOperacional = sistemaOperacional;
    }

    public void setTemperaturaElevada(boolean temperaturaElevada) {
        this.temperaturaElevada = temperaturaElevada;
    }

    public void setTimerCom(Timer timerCom) {
        this.timerCom = timerCom;
    }

    public void setTimerFalha(Timer timerFalha) {
        this.timerFalha = timerFalha;
    }

    public void setTimerShut(Timer timerShut) {
        this.timerShut = timerShut;
    }

    public void setUps(AbstractUPS ups) {
        this.ups = ups;
    }

    public void setUsandoSomenteBateria(boolean usandoSomenteBateria) {
        this.usandoSomenteBateria = usandoSomenteBateria;
    }

    public void setFlagShutFimAut(boolean flagShutFimAut) {
        this.flagShutFimAut = flagShutFimAut;
    }

    public void setShutdownTempoFalha(boolean shutdownTempoFalha) {
        this.shutdownTempoFalha = shutdownTempoFalha;
    }

    public void setAutonomiaMinima(int autonomiaMinima) {
        this.autonomiaMinima = autonomiaMinima;
        this.persistencia.setAutonoMinima(autonomiaMinima);
        this.persistencia.salvaConf();
    }

    public String getNomePCUPS() {
        return this.nomePCUPS;
    }

    public String getNomeUPS() {
        return this.nomeUPS;
    }

    public int getAno() {
        return this.ups.getAno();
    }

    public int getAutonomiaBateria() {
        return this.ups.getAutonomiaBateria();
    }

    public boolean isBateriaBaixa() {
        return this.ups.isBateriaBaixa();
    }

    public boolean isModoRemoto() {
        return this.persistencia.isModoRemoto();
    }

    public boolean isBateriaCarregada() {
        return this.ups.isBateriaCarregada();
    }

    public boolean isBateriaCritica() {
        return this.ups.isBateriaCritica();
    }

    public boolean isBateriaDescarregada() {
        return this.ups.isBateriaDescarregada();
    }

    public boolean isBypassAtivado() {
        return this.ups.isBypassAtivado();
    }

    public boolean isCargaElevada() {
        return this.ups.isCargaElevada();
    }

    public boolean isCarregandoBateria() {
        return this.ups.isCarregandoBateria();
    }

    public boolean isUsandoSomenteBateria() {
        return this.ups.isUsandoSomenteBateria();
    }

    public float getCorrenteEntrada() {
        return this.ups.getCorrenteEntrada();
    }

    public float getCorrenteSaida() {
        return this.ups.getCorrenteSaida();
    }

    public int getDiaMes() {
        return this.ups.getDiaMes();
    }

    public int getDiaSemana() {
        return this.ups.getDiaSemana();
    }

    public boolean[] getDiasSemanaProgramados() {
        return this.ups.getDiasSemanaProgramados();
    }

    public boolean isEntradaLigada() {
        return this.ups.isEntradaLigada();
    }

    public int getExpansorBateria() {
        return this.ups.getExpansorBateria();
    }

    public float getFatorPotenciaCarga() {
        return this.ups.getFatorPotenciaCarga();
    }

    public float getFrequenciaEntrada() {
        return this.ups.getFrequenciaEntrada();
    }

    public float getFrequenciaSaida() {
        return this.ups.getFrequenciaSaida();
    }

    public int getHora() {
        return new GregorianCalendar().get(11);
    }

    public int getHoraDesligar() {
        return this.ups.getHoraDesligar();
    }

    public int getHoraLigar() {
        return this.ups.getHoraLigar();
    }

    public float getLimiteInferiorTensaoEntrada() {
        return this.ups.getLimiteInferiorTensaoEntrada();
    }

    public float getLimiteInferiorTensaoSaida() {
        return this.ups.getLimiteInferiorTensaoSaida();
    }

    public float getLimiteSuperiorTensaoEntrada() {
        return this.ups.getLimiteSuperiorTensaoEntrada();
    }

    public float getLimiteSuperiorTensaoSaida() {
        return this.ups.getLimiteSuperiorTensaoSaida();
    }

    public int getMes() {
        return this.ups.getMes();
    }

    public int getMinutoDesligar() {
        return this.ups.getMinutoDesligar();
    }

    public int getMinutoLigar() {
        return this.ups.getMinutoLigar();
    }

    public int getMinutos() {
        return new GregorianCalendar().get(12);
    }

    public boolean isModoBateria() {
        return this.ups.isModoBateria();
    }

    public boolean isFlagShutdown() {
        return this.flagShutdown;
    }

    public boolean isModoBypass() {
        return this.ups.isModoBypass();
    }

    public boolean isModoRede() {
        return this.ups.isModoRede();
    }

    public int getPercentualBateria() {
        return this.ups.getPercentualBateria();
    }

    public float getPotenciaAparente() {
        return this.ups.getPotenciaAparente();
    }

    public float getPotenciaReal() {
        return this.ups.getPotenciaReal();
    }

    public ProtocoloUPS getProtocoloUPS() {
        return this.ups.getProtocoloUPS();
    }

    public boolean isSaidaLigada() {
        return this.ups.isSaidaLigada();
    }

    public int getSegundos() {
        return this.ups.getSegundos();
    }

    public boolean isSobrecarga() {
        return this.ups.isSobrecarga();
    }

    public boolean isSuperAquecimento() {
        return this.ups.isSuperAquecimento();
    }

    public boolean isTemperaturaElevada() {
        return this.ups.isTemperaturaElevada();
    }

    public float getTemperaturaUPS() {
        return this.ups.getTemperaturaUPS();
    }

    public float getTensaoBateria() {
        return this.ups.getTensaoBateria();
    }

    public float getTensaoBoost() {
        return this.ups.getTensaoBoost();
    }

    public float getTensaoEntrada() {
        return this.ups.getTensaoEntrada();
    }

    public float getTensaoEntradaNominal() {
        return this.ups.getTensaoEntradaNominal();
    }

    public boolean isTensaoEntrada220() {
        return this.ups.isTensaoEntrada220();
    }

    public float getTensaoSaida() {
        return this.ups.getTensaoSaida();
    }

    public boolean isTensaoSaida220() {
        return this.ups.isTensaoSaida220();
    }

    public float getTensaoSaidaNominal() {
        return this.ups.getTensaoSaidaNominal();
    }

    public float getBateriaTensaoNominal() {
        return this.ups.getBateriaTensaoNominal();
    }

    public int getPotenciaNominalVA() {
        return this.ups.getPotenciaNominalVA();
    }

    public int getPotenciaNominalW() {
        return this.ups.getPotenciaNominalW();
    }

    public float getTemperaturaCritica() {
        return this.ups.getTemperaturaCritica();
    }

    public static int getRHINO() {
        return 2;
    }

    public static int getSOLIS() {
        return 1;
    }

    public static int getSOLIS_M11() {
        return 171;
    }

    public AgenteSGM getAgenteSNMP() {
        return this.agenteSNMP;
    }

    public boolean isAutenticacao() {
        return this.autenticacao;
    }

    public int getAutonomiaMinima() {
        return this.autonomiaMinima;
    }

    public int getAutonomiaMinimaPersistencia() {
        return this.persistencia.getAutonoMinima();
    }

    public String getCaminhoScript() {
        return this.caminhoScript;
    }

    public int getDelayTimerCom() {
        return this.delayTimerCom;
    }

    public String[] getDestinatarios() {
        return this.destinatarios;
    }

    public Communication getDriver() {
        return this.driver;
    }

    public String getEnderecoIPLocal() {
        return this.enderecoIPLocal;
    }

    public String getEnderecoSMTP() {
        return this.enderecoSMTP;
    }

    public int getEventoGatilho() {
        return this.eventoGatilho;
    }

    public boolean isFalhaCom() {
        return this.falhaCom;
    }

    public int getFamiliaUPS() {
        return this.familiaUPS;
    }

    public boolean isFlagShutFimAut() {
        return this.flagShutFimAut;
    }

    public DecimalFormat getFormatador() {
        return this.formatador;
    }

    public InterfaceGrafica getGui() {
        return this.gui;
    }

    public HistoricoConsumo getHistCos() {
        return this.histCos;
    }

    public int getHoraDesligarAgendada() {
        return this.horaDesligarAgendada;
    }

    public String getIdioma() {
        return this.idioma;
    }

    public boolean[][] getMensagens() {
        return this.mensagens;
    }

    public int getMinutoDesligarAgendado() {
        return this.minutoDesligarAgendado;
    }

    public int getModeloUPS() {
        return this.modeloUPS;
    }

    public ControleListener[] getOuvintesControle() {
        return this.ouvintesControle;
    }

    public BuscaParametrosXML getParametrosXML() {
        return this.parametrosXML;
    }

    public Persistencia getPersistencia() {
        return this.persistencia;
    }

    public String getPorta() {
        return this.porta;
    }

    public int getPortaSMTP() {
        return this.portaSMTP;
    }

    public boolean[] getProgramacao() {
        return this.programacao;
    }

    public ProtocoloUPS getProtocolo() {
        return this.protocolo;
    }

    public String getRemetente() {
        return this.remetente;
    }

    public String getSenha() {
        return this.senha;
    }

    public boolean isShutdownTempoFalha() {
        return this.shutdownTempoFalha;
    }

    public String getSistemaOperacional() {
        return this.sistemaOperacional;
    }

    public int getTempoFalha() {
        return this.tempoFalha;
    }

    public Timer getTimerCom() {
        return this.timerCom;
    }

    public Timer getTimerFalha() {
        return this.timerFalha;
    }

    public Timer getTimerShut() {
        return this.timerShut;
    }

    public AbstractUPS getUps() {
        return this.ups;
    }

    public String getUsuario() {
        return this.usuario;
    }

    public int getFatorPotenciaEquipamento() {
        return this.ups.getFatorPotenciaEquipamento();
    }

    public UPSDataObject getUPSDataObject() {
        return this.ups;
    }

    public boolean isRedeFalha() {
        return this.redeFalha;
    }

    public String[] getPortas() {
        return this.driver.getPortas();
    }

    public boolean isPrimeiraExecucao() {
        return this.primeiraExecucao;
    }

    public Evento[] getEventos() {
        return this.eventos;
    }

    public Object getIdiomaPersistencia() {
        return this.persistencia.getIdioma();
    }

    public boolean isBatteryTestAvailable() {
        return this.ups.isAutoTesteBateriaAvaliable();
    }

    public int getHoraTestePersistencia() {
        return this.persistencia.getHoraTeste();
    }

    public int getMinutoTestePersistencia() {
        return this.persistencia.getMinutoTeste();
    }

    public int getPeriodoTestePersistencia() {
        return this.persistencia.getPeriodoTeste();
    }

    public boolean getAutoTesteEnabledPersitencia() {
        return this.persistencia.getAutoTesteEnabled();
    }

    public boolean getModoLoggingPersitencia() {
        return this.persistencia.getModoLogging();
    }

    public int getEventoPersistencia() {
        return this.persistencia.getEvento();
    }

    public String getScript() {
        return this.persistencia.getScript();
    }

    public boolean[][] getMensagensPersistencia() {
        return this.persistencia.getMensagens();
    }

    public int getExpansorBateriaPersistencia() {
        return this.persistencia.getExpansorBateria();
    }

    public String getNomeUPSPersistencia() {
        return this.persistencia.getNomeUPS();
    }

    public String getEnderecoSMTPPersistencia() {
        return this.persistencia.getEnderecoSMTP();
    }

    public boolean getFlagAutenticacoPersistencia() {
        return this.persistencia.isFlagAutentic();
    }

    public String getUsuarioPersistencia() {
        return this.persistencia.getUsuario();
    }

    public String getSenhaPersistencia() {
        return this.persistencia.getSenha();
    }

    public String getRemetentePersistencia() {
        return this.persistencia.getRemetente();
    }

    public String[] getDestinatariosPersistencia() {
        return this.persistencia.getDestinatarios();
    }

    public int getPortaSMTPPersistencia() {
        return this.persistencia.getPortaSMTP();
    }

    public int getPortaPedidos() {
        return this.persistencia.getPortaPedidos();
    }

    public String getComunidadeLeitura() {
        return this.persistencia.getComunidadeLeitura();
    }

    public String getComunidadeEscrita() {
        return this.persistencia.getComunidadeEscrita();
    }

    public String getEnderecoGerente() {
        return this.persistencia.getEnderecoGerente();
    }

    public int getPortaEnvio() {
        return this.persistencia.getPortaEnvio();
    }

    public int getVSNMP() {
        return this.persistencia.getVSNMP();
    }

    public int getProtocoloTransportePersistencia() {
        return this.persistencia.getProtocoloTransporte();
    }

    public int getAutonoMinima() {
        return this.persistencia.getAutonoMinima();
    }

    public boolean getFlagShutFimAut() {
        return this.persistencia.isFlagShutFimAut();
    }

    public boolean getFlagShutFalhaEletrica() {
        return this.persistencia.isFlagShutFalhaEletrica();
    }

    public int getTempoFalhaEletrica() {
        return this.persistencia.getTempoFalhaEletrica();
    }

    public boolean getModoRemoto() {
        return this.persistencia.isModoRemoto();
    }

    public int getPortaRemota() {
        return this.persistencia.getPortaRemota();
    }

    public String[] getTipoEventos() {
        return Evento.listaAlarmes;
    }

    public String getProvedorEscolhidoPersitencia() {
        return this.persistencia.getProvedorEscolhido();
    }

    public String getProtocoloSNMP() {
        int i = this.getProtocoloTransportePersistencia();
        if (i == 0) {
            return "UDP";
        }
        return "TCP";
    }

    public int getVersaoSNMP() {
        int i = this.getVSNMP();
        return ++i;
    }

    public double getValorKw() {
        return this.persistencia.getValorKW();
    }

    public boolean isTemperaturaAvaliable() {
        return this.ups.isTemperaturaAvaliable();
    }

    public float getPotenciaRealEntrada() {
        return 0.0f;
    }

    public int getFamiliaUPSPersistencia() {
        return this.persistencia.getFamilia();
    }

    public float getPotenciaAparenteEntrada() {
        return 0.0f;
    }

    public int calculaEstadoBaterias(float bateriaInicial, float bateriaFinal, float Potencia, int tempo) {
        return this.ups.calculaEstadoBaterias(bateriaInicial, bateriaFinal, Potencia, tempo);
    }

    public String getPortaSerial() {
        return this.persistencia.getPorta();
    }

    @Override
    public void fimTesteBateria(int resultado) {
        if (this.isGui()) {
            switch (resultado) {
                case 1: {
                    this.gui.mostraPopUp("ESTADO_BATERIA_OK");
                    break;
                }
                case 0: {
                    this.gui.mostraPopUp("ESTADO_BATERIA_BOM");
                    break;
                }
                case 2: {
                    this.gui.mostraPopUp("ESTADO_BATERIA_RUIM");
                }
            }
        }
    }

    @Override
    public void inicioTesteBateria() {
        if (this.isGui()) {
            this.gui.mostraPopUp("Inicio_Teste_Bateria");
        }
    }

    @Override
    public void testeBateriaAbortado(int res) {
        if (this.isGui()) {
            switch (res) {
                case 1: {
                    this.gui.mostraPopUp("FALHA_TIMEOUT_TESTE_BATERIA");
                    break;
                }
                case 3: {
                    this.gui.mostraPopUp("FALHA_COMUNICACAO_TESTE_BATERIA");
                    break;
                }
                case 2: {
                    this.gui.mostraPopUp("FALHA_BATERIA_BAIXA_TESTE_BATERIA");
                }
            }
        }
    }

    @Override
    public void testeBateriaIndisponivel() {
        if (this.isGui()) {
            this.gui.mostraPopUp("TESTE_BATERIA_NAO_DISPONIVEL");
        }
    }

    public void salvaPersistenciaSMTP(String destinatario, String endServidor, String porta, String remetente, char[] senha, String usuario, String provedorSmtp, boolean flagAutentic) {
        String[] dests = new String[]{destinatario};
        this.persistencia.setDestinatarios(dests);
        this.persistencia.setEnderecoSMTP(endServidor);
        this.persistencia.setPortaSMTP(Integer.parseInt(porta));
        this.persistencia.setRemetente(remetente);
        this.persistencia.setSenha(String.copyValueOf(senha));
        this.persistencia.setUsuario(usuario);
        this.persistencia.setProvedorEscolhido(provedorSmtp);
        this.persistencia.setFlagAutentic(flagAutentic);
        this.persistencia.salvaConf();
    }
}

