/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.config;

import com.sun.xml.tree.XmlDocument;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BuscaParametrosXML {
    private String[] resultados;
    private Document doc;
    private String nomeDocumento;
    private String nohAtual;
    private String familia;
    private Vector<String> historico;
    private String millis;
    private String record;
    private boolean arqRemovido;
    private Vector<Node> res;

    public void setNomeDocumento(String nomeDocumento) {
        this.nomeDocumento = nomeDocumento;
    }

    public synchronized Object[] buscaFamilias() {
        try {
            this.doc = XmlDocument.createXmlDocument(new FileInputStream(this.nomeDocumento), false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        this.res = new Vector();
        this.buscaFamilias(this.doc);
        if (this.res != null) {
            return this.res.toArray();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buscaFamilias(Node noh) {
        if (noh == null) {
            return;
        }
        short tipo = noh.getNodeType();
        switch (tipo) {
            case 9: {
                NodeList Lista = noh.getChildNodes();
                try {
                    int i = 0;
                    while (i <= Lista.getLength() - 1) {
                        this.buscaSerial(Lista.item(i));
                        ++i;
                    }
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            case 1: {
                try {
                    if (noh.getNodeName() != "familia") return;
                    NamedNodeMap atributos = noh.getAttributes();
                    if (!atributos.item(0).getNodeValue().equalsIgnoreCase(this.familia)) {
                        return;
                    }
                    this.res.add(atributos.getNamedItem("nome"));
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            case 3: {
                return;
            }
        }
    }

    private void buscaSerial(Node noh) {
        if (noh == null) {
            return;
        }
        short tipo = noh.getNodeType();
        switch (tipo) {
            case 9: {
                NodeList Lista = noh.getChildNodes();
                try {
                    int i = 0;
                    while (i <= Lista.getLength() - 1) {
                        this.buscaSerial(Lista.item(i));
                        ++i;
                    }
                }
                catch (Exception i) {}
                break;
            }
            case 1: {
                try {
                    NodeList Lista;
                    if (noh.getNodeName() == "familia") {
                        NamedNodeMap atributos = noh.getAttributes();
                        if (!atributos.item(0).getNodeValue().equalsIgnoreCase(this.familia)) {
                            return;
                        }
                    } else if (noh.getNodeName() == "tempoEsperaPorta") {
                        this.nohAtual = "tempoEsperaPorta";
                    } else if (noh.getNodeName() == "baudRate") {
                        this.nohAtual = "baudRate";
                    } else if (noh.getNodeName() == "dataBits") {
                        this.nohAtual = "dataBits";
                    } else if (noh.getNodeName() == "stopBit") {
                        this.nohAtual = "stopBit";
                    } else if (noh.getNodeName() == "paridade") {
                        this.nohAtual = "paridade";
                    } else if (noh.getNodeName() == "delayLeitura") {
                        this.nohAtual = "delayLeitura";
                    }
                    if (noh.getNodeName() != "comunicacao" && noh.getNodeName() != "familia" && noh.getNodeName() != "serial" && noh.getNodeName() != "tempoEsperaPorta" && noh.getNodeName() != "baudRate" && noh.getNodeName() != "dataBits" && noh.getNodeName() != "stopBit" && noh.getNodeName() != "paridade" && noh.getNodeName() != "delayLeitura" || (Lista = noh.getChildNodes()) == null) break;
                    int i = 0;
                    while (i <= Lista.getLength() - 1) {
                        this.buscaSerial(Lista.item(i));
                        ++i;
                    }
                }
                catch (Exception exception) {}
                break;
            }
            case 3: {
                if (noh.getNodeValue().trim().length() == 0) break;
                try {
                    if (this.nohAtual == "tempoEsperaPorta") {
                        this.resultados[0] = noh.getNodeValue();
                        break;
                    }
                    if (this.nohAtual == "baudRate") {
                        this.resultados[1] = noh.getNodeValue();
                        break;
                    }
                    if (this.nohAtual == "dataBits") {
                        this.resultados[2] = noh.getNodeValue();
                        break;
                    }
                    if (this.nohAtual == "stopBit") {
                        this.resultados[3] = noh.getNodeValue();
                        break;
                    }
                    if (this.nohAtual == "paridade") {
                        this.resultados[4] = noh.getNodeValue();
                        break;
                    }
                    if (this.nohAtual != "delayLeitura") break;
                    this.resultados[5] = noh.getNodeValue();
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized String[] configuraPorta(String familia, String tipo) {
        this.familia = familia;
        if (tipo.equalsIgnoreCase("serial")) {
            try {
                this.doc = XmlDocument.createXmlDocument(new FileInputStream(this.nomeDocumento), false);
            }
            catch (IOException | SAXException e) {
                e.printStackTrace();
            }
            this.resultados = new String[6];
            this.buscaSerial(this.doc);
        }
        return this.resultados;
    }

    private void imprimeRegistrosHistorico(Node noh) {
        if (noh == null) {
            return;
        }
        short tipo = noh.getNodeType();
        switch (tipo) {
            case 9: {
                NodeList Lista = noh.getChildNodes();
                try {
                    int i = 0;
                    while (i <= Lista.getLength() - 1) {
                        this.imprimeRegistrosHistorico(Lista.item(i));
                        ++i;
                    }
                }
                catch (Exception i) {}
                break;
            }
            case 1: {
                try {
                    NodeList Lista;
                    if (noh.getNodeName() == "date") {
                        this.nohAtual = "date";
                    }
                    if (noh.getNodeName() == "millis") {
                        this.nohAtual = "millis";
                    } else if (noh.getNodeName() == "message") {
                        this.nohAtual = "message";
                    }
                    if (noh.getNodeName() != "log" && noh.getNodeName() != "record" && noh.getNodeName() != "date" && noh.getNodeName() != "millis" && noh.getNodeName() != "message" || (Lista = noh.getChildNodes()) == null) break;
                    int i = 0;
                    while (i <= Lista.getLength() - 1) {
                        this.imprimeRegistrosHistorico(Lista.item(i));
                        ++i;
                    }
                }
                catch (Exception exception) {}
                break;
            }
            case 3: {
                if (noh.getNodeValue().trim().length() == 0) break;
                try {
                    if (this.nohAtual == "date") {
                        this.record = noh.getNodeValue();
                        break;
                    }
                    if (this.nohAtual == "millis") {
                        this.record = String.valueOf(this.record) + "_" + noh.getNodeValue();
                        break;
                    }
                    if (this.nohAtual != "message") break;
                    this.record = String.valueOf(this.record) + "_" + noh.getNodeValue();
                    this.historico.add(this.record);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized Vector<String> getRegistrosHistorico() {
        try {
            this.doc = XmlDocument.createXmlDocument(new FileInputStream(this.nomeDocumento), false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        this.historico = new Vector();
        this.imprimeRegistrosHistorico(this.doc);
        return this.historico;
    }

    private synchronized void removeRegistro(Node noh) {
        if (noh == null) {
            return;
        }
        short tipo = noh.getNodeType();
        switch (tipo) {
            case 9: {
                NodeList Lista = noh.getChildNodes();
                try {
                    int i = 0;
                    while (i <= Lista.getLength() - 1) {
                        this.removeRegistro(Lista.item(i));
                        ++i;
                    }
                }
                catch (Exception i) {}
                break;
            }
            case 1: {
                try {
                    if (noh.getNodeName() != "record" && noh.getNodeName() == "millis") {
                        this.nohAtual = "millis";
                    }
                    if (noh.getNodeName() != "log" && noh.getNodeName() != "record" && noh.getNodeName() != "millis") break;
                    NodeList Lista = noh.getChildNodes();
                    if (Lista != null) {
                        int i = 0;
                        while (i <= Lista.getLength() - 1) {
                            this.removeRegistro(Lista.item(i));
                            if (this.arqRemovido) break;
                            ++i;
                        }
                    }
                    if (noh.getNodeName() != "log") break;
                }
                catch (Exception exception) {}
                break;
            }
            case 3: {
                if (noh.getNodeValue().trim().length() == 0) break;
                try {
                    if (this.nohAtual != "millis" || !noh.getNodeValue().equals(this.millis)) break;
                    this.arqRemovido = true;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized boolean deletaRegistroHistorico(String millis) {
        this.millis = millis;
        try {
            this.doc = XmlDocument.createXmlDocument(new FileInputStream(this.nomeDocumento), false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        this.arqRemovido = false;
        this.removeRegistro(this.doc);
        return this.arqRemovido;
    }

    public void buscaAlarmes(Node noh) {
        if (noh == null) {
            return;
        }
        short tipo = noh.getNodeType();
        switch (tipo) {
            case 9: {
                NodeList Lista = noh.getChildNodes();
                try {
                    int i = 0;
                    while (i <= Lista.getLength() - 1) {
                        this.buscaAlarmes(Lista.item(i));
                        ++i;
                    }
                }
                catch (Exception i) {}
                break;
            }
            case 1: {
                try {
                    NodeList Lista;
                    if (noh.getNodeName() == "alarme") {
                        this.nohAtual = "alarme";
                    }
                    if ((Lista = noh.getChildNodes()) == null) break;
                    int i = 0;
                    while (i <= Lista.getLength() - 1) {
                        this.buscaAlarmes(Lista.item(i));
                        ++i;
                    }
                }
                catch (Exception exception) {}
                break;
            }
            case 3: {
                if (noh.getNodeValue().trim().length() == 0) break;
                try {
                    if (this.nohAtual != "alarme") break;
                    this.historico.add(noh.getNodeValue());
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized String[] configuraAlarmes() {
        try {
            this.doc = XmlDocument.createXmlDocument(new FileInputStream(this.nomeDocumento), false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        this.historico = new Vector();
        this.buscaAlarmes(this.doc);
        if (this.historico != null) {
            String[] res = new String[this.historico.size()];
            int i = 0;
            while (i < this.historico.size()) {
                res[i] = this.historico.get(i).toString();
                ++i;
            }
            return res;
        }
        return null;
    }

    public static void main(String[] args) {
    }
}

