###############################################################################
# Project: Logic Controls Spooler Driver - Mini-Printers
# File: lcithermal-spooldrv.spec
# Version: $Name:  $
# Revision: $Id: lcithermal-spooldrv.spec,v 1.1 2008/10/01 12:55:46 b1106104 Exp $
#
# Device: Thermal mini-printers
# Logic Controls models:
# . mini-printers: LR3000
#
# Author: 
# . Developed by Logic Controls.
#
# Description of this file contents:
# . SPEC file for generating an RPM package
###############################################################################

Summary: Logic Controls Spooler Driver for Mini-Printers
Name: lcithermal-spooldrv
Version: 1.0
Release: 1
Packager: Logic Controls <http://www.logiccontrols.com>
Vendor: Logic Controls, Inc.
License: Other
Group: System Environment/Libraries
Source: %{name}-%{version}.tar.gz
Requires: cups cups-libs
BuildRequires: cups-devel

%description
This package contains all necessary files for printing with CUPS to Logic Controls Mini-Printers.
Included is a CUPS printer driver for all printer models, together with the corresponding PPDs.
Please use the CUPS administration interface at http://localhost:631 to configure a printer using this driver.

Developed by Logic Controls, Inc.

%prep
%setup -q

%build
make

%install
make install

%clean
make uninstall
                                                                                                                             
%files
%defattr(644, root, root)
%attr(755, root, root) /usr/lib/cups/filter/rastertolci
/usr/share/cups/model/lcithermal-58mm.ppd.gz
/usr/share/cups/model/lcithermal-76_80mm.ppd.gz
/usr/share/cups/model/lcithermal-112mm.ppd.gz

%post
# SuSE Professional 9 and later supports only "restart", not "reload"
# Red Hat Linux 8 and older supports only "restart", not "reload"

# Newer Linux distributions use the "cups" name for the service
if [ -x /etc/init.d/cups ]; then
  /etc/init.d/cups restart
fi

# Older Linux distributions use the "cupsd" name for the service
if [ -x /etc/init.d/cupsd ]; then
  /etc/init.d/cupsd restart
fi

%postun
# SuSE Professional 9 and later supports only "restart", not "reload"
# Red Hat Linux 8 and older supports only "restart", not "reload"

# Newer Linux distributions use the "cups" name for the service
if [ -x /etc/init.d/cups ]; then
  /etc/init.d/cups restart
fi

# Older Linux distributions use the "cupsd" name for the service
if [ -x /etc/init.d/cupsd ]; then
  /etc/init.d/cupsd restart
fi

%changelog
* Mon Feb 23 2009 David <wong@logiccontrols.com>
- Change it to logic controls name space, base on version 1.0-1
